/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.lock.storage.StorageLock;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SubStorage
implements Storage {
    private final Key prefix;
    private final Storage origin;

    public SubStorage(Key prefix, Storage origin) {
        this.prefix = prefix;
        this.origin = origin;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return this.origin.exists(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key filter) {
        Pattern ptn = Pattern.compile(String.format("%s/", this.prefix.string()));
        return this.origin.list(new PrefixedKed(this.prefix, filter)).thenApply(keys -> keys.stream().map(key -> new Key.From(ptn.matcher(key.string()).replaceFirst(""))).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        CompletableFuture<Void> res = Key.ROOT.equals(key) ? new CompletableFutureSupport.Failed(new IOException("Unable to save to root")).get() : this.origin.save(new PrefixedKed(this.prefix, key), content);
        return res;
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return this.origin.move(new PrefixedKed(this.prefix, source), new PrefixedKed(this.prefix, destination));
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return this.origin.size(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return this.origin.value(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.origin.delete(new PrefixedKed(this.prefix, key));
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    public static final class PrefixedKed
    extends Key.Wrap {
        public PrefixedKed(Key prefix, Key key) {
            super(new Key.From(prefix, key));
        }
    }
}

