/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.s3.Bucket;
import com.artipie.asto.s3.EstimatedContentCompliment;
import com.artipie.asto.s3.InternalExceptionHandle;
import com.artipie.asto.s3.MultipartUpload;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public final class S3Storage
implements Storage {
    private static final long MIN_MULTIPART = 0xA00000L;
    private final S3AsyncClient client;
    private final String bucket;
    private final boolean multipart;

    public S3Storage(S3AsyncClient client, String bucket) {
        this(client, bucket, true);
    }

    public S3Storage(S3AsyncClient client, String bucket, boolean multipart) {
        this.client = client;
        this.bucket = bucket;
        this.multipart = multipart;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        CompletableFuture<Boolean> exists = new CompletableFuture<Boolean>();
        this.client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(key.string()).build()).handle((response, throwable) -> {
            if (throwable == null) {
                exists.complete(true);
            } else if (throwable.getCause() instanceof NoSuchKeyException) {
                exists.complete(false);
            } else {
                exists.completeExceptionally((Throwable)throwable);
            }
            return response;
        });
        return exists;
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return this.client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucket).prefix(prefix.string()).build()).thenApply(response -> response.contents().stream().map(S3Object::key).map(Key.From::new).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        Content.OneTime onetime = new Content.OneTime(content);
        CompletionStage<Content> result = this.multipart ? new EstimatedContentCompliment(onetime, 0xA00000L).estimate() : new EstimatedContentCompliment(onetime).estimate();
        return result.thenCompose(estimated -> {
            CompletableFuture<Void> res = this.multipart && estimated.size().filter(x -> x > 0xA00000L).isPresent() ? this.putMultipart(key, (Content)estimated) : this.put(key, (Content)estimated);
            return res;
        }).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return this.client.copyObject((CopyObjectRequest)CopyObjectRequest.builder().copySource(String.format("%s/%s", this.bucket, source.string())).bucket(this.bucket).key(destination.string()).build()).thenCompose(copied -> this.client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(source.string()).build()).thenCompose(deleted -> CompletableFuture.allOf(new CompletableFuture[0])));
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return ((CompletableFuture)((CompletableFuture)this.client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(key.string()).build()).thenApply(HeadObjectResponse::contentLength)).handle((BiFunction)new InternalExceptionHandle(NoSuchKeyException.class, cause -> new ValueNotFoundException(key, (Throwable)cause)))).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        CompletableFuture<Content> promise = new CompletableFuture<Content>();
        this.client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(key.string()).build(), (AsyncResponseTransformer)new ResponseAdapter(promise));
        return ((CompletableFuture)((CompletableFuture)promise.handle((BiFunction)new InternalExceptionHandle(NoSuchKeyException.class, cause -> new ValueNotFoundException(key, (Throwable)cause)))).thenCompose(Function.identity())).thenApply(Content.OneTime::new);
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.exists(key).thenCompose(exists -> {
            FailedCompletionStage deleted = exists != false ? this.client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(key.string()).build()).thenCompose(response -> CompletableFuture.allOf(new CompletableFuture[0])) : new FailedCompletionStage(new IllegalArgumentException(String.format("Key does not exist: %s", key)));
            return deleted;
        });
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    private CompletableFuture<Void> put(Key key, Content content) {
        return this.client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(key.string()).build(), (AsyncRequestBody)new ContentBody(content)).thenApply(ignored -> null);
    }

    private CompletableFuture<Void> putMultipart(Key key, Content updated) {
        return ((CompletableFuture)this.client.createMultipartUpload((CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucket).key(key.string()).build()).thenApply(created -> new MultipartUpload(new Bucket(this.client, this.bucket), key, created.uploadId()))).thenCompose(upload -> upload.upload(updated).handle((ignored, throwable) -> {
            CompletionStage<Void> finished;
            if (throwable == null) {
                finished = upload.complete();
            } else {
                CompletableFuture<Void> promise = new CompletableFuture<Void>();
                finished = promise;
                upload.abort().whenComplete((ignore, ex) -> promise.completeExceptionally((Throwable)throwable));
            }
            return finished;
        }).thenCompose(Function.identity()));
    }

    private static class ResponseAdapter
    implements AsyncResponseTransformer<GetObjectResponse, Content> {
        private final CompletableFuture<Content> promise;
        private Long length;

        ResponseAdapter(CompletableFuture<Content> promise) {
            this.promise = promise;
        }

        public CompletableFuture<Content> prepare() {
            return this.promise;
        }

        public void onResponse(GetObjectResponse response) {
            this.length = response.contentLength();
        }

        public void onStream(SdkPublisher<ByteBuffer> publisher) {
            this.promise.complete(new Content.From(Optional.ofNullable(this.length), (Publisher<ByteBuffer>)publisher));
        }

        public void exceptionOccurred(Throwable throwable) {
            this.promise.completeExceptionally(throwable);
        }
    }

    private static class ContentBody
    implements AsyncRequestBody {
        private final Content source;

        ContentBody(Content source) {
            this.source = source;
        }

        public Optional<Long> contentLength() {
            return this.source.size();
        }

        public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
            this.source.subscribe(subscriber);
        }
    }
}

