/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.ArtipieException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Key {
    public static final String DELIMITER = "/";
    public static final Comparator<Key> CMP_STRING = Comparator.comparing(Key::string);
    public static final Key ROOT = new From(Collections.emptyList());

    public String string();

    public Optional<Key> parent();

    public List<String> parts();

    public static final class From
    implements Key {
        private final List<String> parts;

        public From(String parts) {
            this(parts.split(Key.DELIMITER));
        }

        public From(String ... parts) {
            this(Arrays.asList(parts));
        }

        public From(Key first, Key second) {
            this(Stream.concat(new From((Key)first, (String[])new String[0]).parts.stream(), new From((Key)second, (String[])new String[0]).parts.stream()).collect(Collectors.toList()));
        }

        public From(Key base, String ... parts) {
            this(Stream.concat(new From((String)base.string()).parts.stream(), Arrays.stream(parts)).collect(Collectors.toList()));
        }

        public From(List<String> parts) {
            this.parts = parts.size() == 1 && parts.get(0).isEmpty() ? Collections.emptyList() : parts.stream().flatMap(part -> Arrays.stream(part.split(Key.DELIMITER))).collect(Collectors.toList());
        }

        @Override
        public String string() {
            for (String part : this.parts) {
                if (part.isEmpty()) {
                    throw new ArtipieException("Empty parts are not allowed");
                }
                if (!part.contains(Key.DELIMITER)) continue;
                throw new ArtipieException(String.format("Invalid part: '%s'", part));
            }
            return String.join((CharSequence)Key.DELIMITER, this.parts);
        }

        @Override
        public Optional<Key> parent() {
            Optional<Key> parent = this.parts.isEmpty() ? Optional.empty() : Optional.of(new From(this.parts.subList(0, this.parts.size() - 1)));
            return parent;
        }

        @Override
        public List<String> parts() {
            return Collections.unmodifiableList(this.parts);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            if (another == null || this.getClass() != another.getClass()) {
                return false;
            }
            From from = (From)another;
            return Objects.equals(this.parts, from.parts);
        }

        public int hashCode() {
            return Objects.hash(this.parts);
        }

        public String toString() {
            return this.string();
        }
    }

    public static abstract class Wrap
    implements Key {
        private final Key origin;

        protected Wrap(Key origin) {
            this.origin = origin;
        }

        @Override
        public final String string() {
            return this.origin.string();
        }

        @Override
        public Optional<Key> parent() {
            return this.origin.parent();
        }

        @Override
        public List<String> parts() {
            return this.origin.parts();
        }

        public final String toString() {
            return this.string();
        }

        public boolean equals(Object another) {
            return this.origin.equals(another);
        }

        public int hashCode() {
            return this.origin.hashCode();
        }
    }
}

