/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.ArtipieException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface Storage {
    public CompletableFuture<Boolean> exists(Key var1);

    public CompletableFuture<Collection<Key>> list(Key var1);

    public CompletableFuture<Void> save(Key var1, Content var2);

    public CompletableFuture<Void> move(Key var1, Key var2);

    @Deprecated
    default public CompletableFuture<Long> size(Key key) {
        return this.metadata(key).thenApply(meta -> (Long)((Optional)((Object)meta.read(Meta.OP_SIZE))).orElseThrow(() -> new ArtipieException(String.format("SIZE could't be read for %s key", key.string()))));
    }

    public CompletableFuture<? extends Meta> metadata(Key var1);

    public CompletableFuture<Content> value(Key var1);

    public CompletableFuture<Void> delete(Key var1);

    default public CompletableFuture<Void> deleteAll(Key prefix) {
        return this.list(prefix).thenCompose(keys -> {
            CompletionStage<Void> res = CompletableFuture.allOf(new CompletableFuture[0]);
            for (Key key : keys) {
                res = res.thenCompose(noth -> this.delete(key));
            }
            return res;
        });
    }

    public <T> CompletionStage<T> exclusively(Key var1, Function<Storage, CompletionStage<T>> var2);

    public static abstract class Wrap
    implements Storage {
        private final Storage delegate;

        protected Wrap(Storage delegate) {
            this.delegate = delegate;
        }

        @Override
        public final CompletableFuture<Boolean> exists(Key key) {
            return this.delegate.exists(key);
        }

        @Override
        public final CompletableFuture<Collection<Key>> list(Key prefix) {
            return this.delegate.list(prefix);
        }

        @Override
        public final CompletableFuture<Void> save(Key key, Content content) {
            return this.delegate.save(key, content);
        }

        @Override
        public final CompletableFuture<Void> move(Key source, Key destination) {
            return this.delegate.move(source, destination);
        }

        @Override
        public final CompletableFuture<Long> size(Key key) {
            return this.delegate.size(key);
        }

        @Override
        public final CompletableFuture<Content> value(Key key) {
            return this.delegate.value(key);
        }

        @Override
        public final CompletableFuture<Void> delete(Key key) {
            return this.delegate.delete(key);
        }

        @Override
        public final CompletableFuture<Void> deleteAll(Key prefix) {
            return this.delegate.deleteAll(prefix);
        }

        @Override
        public final <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
            return this.delegate.exclusively(key, operation);
        }
    }
}

