/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.fs.VertxRxFile;
import com.artipie.asto.lock.storage.StorageLock;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.CompletableInterop;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Vertx;
import io.vertx.core.file.CopyOptions;
import io.vertx.reactivex.RxHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public final class VertxFileStorage
implements Storage {
    private final Path dir;
    private final io.vertx.reactivex.core.Vertx vertx;

    public VertxFileStorage(Path path, io.vertx.reactivex.core.Vertx vertx) {
        this.dir = path;
        this.vertx = vertx;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Path path = this.path(key);
            return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
        }).subscribeOn(RxHelper.blockingScheduler((Vertx)this.vertx.getDelegate())).to(SingleInterop.get())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Collection<Object> keys;
            Path path = this.path(prefix);
            if (Files.exists(path, new LinkOption[0])) {
                int dirnamelen = Key.ROOT.equals(prefix) ? path.toString().length() + 1 : path.toString().length() - prefix.string().length();
                try {
                    keys = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).map(p -> p.substring(dirnamelen)).map(s -> s.split(FileSystems.getDefault().getSeparator().replace("\\", "\\\\"))).map(Key.From::new).sorted(Comparator.comparing(Key.From::string)).collect(Collectors.toList());
                }
                catch (IOException iex) {
                    throw new ArtipieIOException(iex);
                }
            } else {
                keys = Collections.emptyList();
            }
            Logger.info((Object)this, (String)"Found %d objects by the prefix \"%s\" in %s by %s: %s", (Object[])new Object[]{keys.size(), prefix.string(), this.dir, path, keys});
            return keys;
        }).subscribeOn(RxHelper.blockingScheduler((Vertx)this.vertx.getDelegate())).to(SingleInterop.get())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Path tmp = Paths.get(this.dir.toString(), String.format("%s.%s.tmp", key.string(), UUID.randomUUID()));
            tmp.getParent().toFile().mkdirs();
            return tmp;
        }).subscribeOn(RxHelper.blockingScheduler((Vertx)this.vertx.getDelegate())).flatMapCompletable(tmp -> new VertxRxFile((Path)tmp, this.vertx).save((Flowable<ByteBuffer>)Flowable.fromPublisher((Publisher)content)).andThen((CompletableSource)this.vertx.fileSystem().rxMove(tmp.toString(), this.path(key).toString(), new CopyOptions().setReplaceExisting(true))).onErrorResumeNext(throwable -> new VertxRxFile((Path)tmp, this.vertx).delete().andThen((CompletableSource)Completable.error((Throwable)throwable)))).to(CompletableInterop.await())).thenApply(o -> null).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Path dest = this.path(destination);
            dest.getParent().toFile().mkdirs();
            return dest;
        }).subscribeOn(RxHelper.blockingScheduler((Vertx)this.vertx.getDelegate())).flatMapCompletable(dest -> new VertxRxFile(this.path(source), this.vertx).move((Path)dest)).to(CompletableInterop.await())).thenApply(file -> null).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return ((CompletionStage)new VertxRxFile(this.path(key), this.vertx).delete().to(CompletableInterop.await())).toCompletableFuture().thenCompose(ignored -> CompletableFuture.allOf(new CompletableFuture[0]));
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        Object res = Key.ROOT.equals(key) ? new CompletableFutureSupport.Failed(new ArtipieIOException("Unable to load from root")).get() : VertxFileStorage.size(this.path(key)).thenApply(size -> new Content.OneTime(new Content.From((long)size, (Publisher<ByteBuffer>)new VertxRxFile(this.path(key), this.vertx).flow())));
        return res;
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    @Override
    @Deprecated
    public CompletableFuture<Long> size(Key key) {
        return VertxFileStorage.size(this.path(key));
    }

    @Override
    public CompletableFuture<? extends Meta> metadata(Key key) {
        return CompletableFuture.completedFuture(Meta.EMPTY);
    }

    private Path path(Key key) {
        return Paths.get(this.dir.toString(), key.string());
    }

    private static CompletableFuture<Long> size(Path path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Files.size(path);
            }
            catch (NoSuchFileException fex) {
                throw new ValueNotFoundException(Key.ROOT, (Throwable)fex);
            }
            catch (IOException iex) {
                throw new ArtipieIOException(iex);
            }
        });
    }
}

