/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.rx;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.rx.RxStorage;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class RxCopy {
    private static final Integer DEFLT_PARALLELISM = Runtime.getRuntime().availableProcessors();
    private final RxStorage from;
    private final Optional<Collection<Key>> keys;
    private final Integer parallelism;

    public RxCopy(RxStorage from) {
        this(from, Optional.empty(), DEFLT_PARALLELISM);
    }

    public RxCopy(RxStorage from, Collection<Key> keys) {
        this(from, Optional.of(keys), DEFLT_PARALLELISM);
    }

    public RxCopy(RxStorage from, Collection<Key> keys, Integer parallelism) {
        this(from, Optional.of(keys), parallelism);
    }

    private RxCopy(RxStorage from, Optional<Collection<Key>> keys, Integer parallelism) {
        this.from = from;
        this.keys = keys;
        this.parallelism = parallelism;
    }

    public Completable copy(RxStorage to) {
        return Completable.concat((Publisher)this.keys.map(Flowable::fromIterable).orElseGet(() -> this.from.list(Key.ROOT).flattenAsFlowable(ks -> ks)).map(key -> Completable.defer(() -> to.save((Key)key, new Content.From((Publisher<ByteBuffer>)this.from.value((Key)key).flatMapPublisher(cnt -> cnt))))).buffer(this.parallelism.intValue()).map(Completable::merge));
    }
}

