/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.streams;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.misc.UncheckedIOConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.cqfn.rio.Buffers;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.stream.ReactiveInputStream;
import org.cqfn.rio.stream.ReactiveOutputStream;
import org.reactivestreams.Publisher;

public final class StorageValuePipeline<R> {
    private final Storage asto;
    private final Key read;
    private final Key write;

    public StorageValuePipeline(Storage asto, Key read, Key write) {
        this.asto = asto;
        this.read = read;
        this.write = write;
    }

    public StorageValuePipeline(Storage asto, Key key) {
        this(asto, key, key);
    }

    public CompletionStage<Void> process(BiConsumer<Optional<InputStream>, OutputStream> action) {
        return this.processWithResult((opt, input) -> {
            action.accept((Optional<InputStream>)opt, (OutputStream)input);
            return null;
        }).thenAccept(nothing -> {});
    }

    public CompletionStage<R> processWithResult(BiFunction<Optional<InputStream>, OutputStream, R> action) {
        return this.asto.exists(this.read).thenCompose(exists -> {
            Object result;
            CompletionStage future;
            Optional<Object> oinput = Optional.empty();
            Optional<Object> oout = Optional.empty();
            try (PipedOutputStream resout = new PipedOutputStream();){
                CompletionStage<Void> tmp;
                if (exists.booleanValue()) {
                    oinput = Optional.of(new PipedInputStream());
                    PipedOutputStream tmpout = new PipedOutputStream((PipedInputStream)oinput.get());
                    oout = Optional.of(tmpout);
                    tmp = this.asto.value(this.read).thenCompose(input -> new ReactiveOutputStream((OutputStream)tmpout).write((Publisher)input, WriteGreed.SYSTEM));
                } else {
                    tmp = CompletableFuture.allOf(new CompletableFuture[0]);
                    oinput = Optional.empty();
                }
                PipedInputStream src = new PipedInputStream(resout);
                future = tmp.thenCompose(nothing -> this.asto.save(this.write, new Content.From((Publisher<ByteBuffer>)new ReactiveInputStream((InputStream)src).read((Buffers)Buffers.Standard.K8))));
                result = action.apply(oinput, resout);
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
            finally {
                oinput.ifPresent(new UncheckedIOConsumer<InputStream>(InputStream::close));
                oout.ifPresent(new UncheckedIOConsumer<PipedOutputStream>(PipedOutputStream::close));
            }
            return future.thenApply(nothing -> result);
        });
    }
}

