/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.UriClientSlice;
import com.artipie.http.client.auth.AuthClientSlice;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.slice.ContentWithSize;
import io.reactivex.Flowable;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonString;
import org.reactivestreams.Publisher;

public final class ArtipieStorage
implements Storage {
    private final Slice remote;

    public ArtipieStorage(ClientSlices clients, URI remote) {
        this((Slice)new UriClientSlice(clients, remote));
    }

    ArtipieStorage(Slice remote) {
        this.remote = remote;
    }

    public ArtipieStorage(ClientSlices clients, URI remote, Authenticator auth) {
        this((Slice)new AuthClientSlice((Slice)new UriClientSlice(clients, remote), auth));
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        CompletableFuture<Collection<Key>> promise = new CompletableFuture<Collection<Key>>();
        this.remote.response(new RequestLine(RqMethod.GET, ArtipieStorage.uri(prefix)).toString(), (Iterable)new Headers.From("Accept", "application/json"), (Publisher)Content.EMPTY).send((status, rsheaders, rsbody) -> {
            CompletableFuture term = new CompletableFuture();
            if (status.success()) {
                new PublisherAs((Publisher<ByteBuffer>)Flowable.fromPublisher((Publisher)rsbody).doOnError(term::completeExceptionally).doOnTerminate(() -> term.complete(null))).string(StandardCharsets.UTF_8).thenApply(s -> promise.complete(ArtipieStorage.parse(s)));
            } else {
                promise.completeExceptionally(new ArtipieIOException(String.format("Cannot get lists blobs contained in given path [prefix=%s, status=%s]", prefix, status)));
            }
            return term;
        });
        return promise;
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return this.remote.response(new RequestLine(RqMethod.PUT, ArtipieStorage.uri(key)).toString(), (Iterable)new Headers.From((Map.Entry)new ContentLength((Number)content.size().get())), (Publisher)content).send((status, rsheaders, rsbody) -> {
            CompletionStage<Void> res = status.success() ? CompletableFuture.allOf(new CompletableFuture[0]) : new FailedCompletionStage(new ArtipieIOException(String.format("Entry is not created [key=%s, status=%s]", key, status)));
            return res;
        }).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<? extends Meta> metadata(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        CompletableFuture<Content> promise = new CompletableFuture<Content>();
        this.remote.response(new RequestLine(RqMethod.GET, ArtipieStorage.uri(key)).toString(), (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY).send((status, rsheaders, rsbody) -> {
            CompletableFuture term = new CompletableFuture();
            if (status.success()) {
                promise.complete((Content)new ContentWithSize(rsbody, (Iterable)rsheaders));
            } else {
                promise.completeExceptionally(new ArtipieIOException(String.format("Cannot get a value [key=%s, status=%s]", key, status)));
            }
            return term;
        });
        return promise;
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.remote.response(new RequestLine(RqMethod.DELETE, ArtipieStorage.uri(key)).toString(), (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY).send((status, rsheaders, rsbody) -> {
            CompletionStage<Void> res = status.success() ? CompletableFuture.allOf(new CompletableFuture[0]) : new FailedCompletionStage(new ArtipieIOException(String.format("Entry is not deleted [key=%s, status=%s]", key, status)));
            return res;
        }).toCompletableFuture();
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        throw new UnsupportedOperationException();
    }

    private static Collection<Key> parse(String json) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            Collection collection = reader.readArray().stream().map(v -> (JsonString)v).map(js -> new Key.From(js.getString())).collect(Collectors.toList());
            return collection;
        }
    }

    private static String uri(Key key) {
        return String.format("/%s", key);
    }
}

