/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import com.artipie.asto.Storage;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingStorage
implements Storage {
    private final Logger logger;
    private final Level level;
    private final Storage storage;

    public LoggingStorage(Storage storage) {
        this(Level.FINE, storage);
    }

    public LoggingStorage(Level level, Storage storage) {
        this.level = level;
        this.storage = storage;
        this.logger = Logger.getLogger(this.storage.getClass().getCanonicalName());
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return this.storage.exists(key).thenApply(result -> {
            this.log("Exists '%s': %s", key.string(), result);
            return result;
        });
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return this.storage.list(prefix).thenApply(result -> {
            this.log("List '%s': %s", prefix.string(), result.size());
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return this.storage.save(key, content).thenApply(result -> {
            this.log("Save '%s': %s", key.string(), content.size());
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return this.storage.move(source, destination).thenApply(result -> {
            this.log("Move '%s' '%s'", source.string(), destination.string());
            return result;
        });
    }

    @Override
    @Deprecated
    public CompletableFuture<Long> size(Key key) {
        return this.storage.size(key).thenApply(result -> {
            this.log("Size '%s': %s", key.string(), result);
            return result;
        });
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return this.storage.value(key).thenApply(result -> {
            this.log("Value '%s': %s", key.string(), result.size());
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.storage.delete(key).thenApply(result -> {
            this.log("Delete '%s'", key.string());
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> deleteAll(Key prefix) {
        return this.storage.deleteAll(prefix).thenApply(result -> {
            this.log("Delete all keys prefixed by '%s'", prefix.string());
            return result;
        });
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return this.storage.exclusively(key, operation).thenApply(result -> {
            this.log("Exclusively for '%s': %s", key, operation);
            return result;
        });
    }

    @Override
    public CompletableFuture<? extends Meta> metadata(Key key) {
        return this.storage.metadata(key).thenApply(result -> {
            this.log("Metadata '%s': %s", key.string(), result);
            return result;
        });
    }

    private void log(String msg, Object ... args) {
        this.logger.log(this.level, String.format(msg, args));
    }
}

