/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.reactivestreams.Publisher;

public class Splitting {
    private final ByteBuffer source;
    private final int size;

    public Splitting(ByteBuffer source, int size) {
        this.source = source;
        this.size = size;
    }

    public Publisher<ByteBuffer> publisher() {
        Flowable res;
        int remaining = this.source.remaining();
        if (remaining > this.size) {
            ArrayList<ByteBuffer> parts = new ArrayList<ByteBuffer>(remaining / this.size + 1);
            while (remaining > 0) {
                byte[] bytes = remaining > this.size ? new byte[this.size] : new byte[remaining];
                this.source.get(bytes);
                parts.add(ByteBuffer.wrap(bytes));
                remaining = this.source.remaining();
            }
            res = Flowable.fromIterable(parts);
        } else {
            res = Flowable.just((Object)this.source);
        }
        return res;
    }
}

