/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.cache;

import com.artipie.asto.Content;
import com.jcabi.log.Logger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

@FunctionalInterface
public interface Remote
extends Supplier<CompletionStage<Optional<? extends Content>>> {
    public static final Remote EMPTY = () -> CompletableFuture.completedFuture(Optional.empty());

    @Override
    public CompletionStage<Optional<? extends Content>> get();

    public static final class Failed
    implements Remote {
        private final Throwable reason;

        public Failed(Throwable reason) {
            this.reason = reason;
        }

        @Override
        public CompletionStage<Optional<? extends Content>> get() {
            CompletableFuture<Optional<? extends Content>> res = new CompletableFuture<Optional<? extends Content>>();
            res.completeExceptionally(this.reason);
            return res;
        }
    }

    public static class WithErrorHandling
    implements Remote {
        private final Remote origin;

        public WithErrorHandling(Remote origin) {
            this.origin = origin;
        }

        @Override
        public CompletionStage<Optional<? extends Content>> get() {
            return this.origin.get().handle((content, throwable) -> {
                Optional res;
                if (throwable == null) {
                    res = content;
                } else {
                    Logger.error(this.origin.getClass(), (String)throwable.getMessage());
                    res = Optional.empty();
                }
                return res;
            });
        }
    }
}

