/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import com.artipie.asto.OneTimePublisher;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.fs.FileMeta;
import com.artipie.asto.lock.storage.StorageLock;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cqfn.rio.file.File;
import org.reactivestreams.Publisher;
import wtf.g4s8.tuples.Pair;

public final class FileStorage
implements Storage {
    private final Path dir;

    @Deprecated
    public FileStorage(Path path, Object nothing) {
        this(path);
    }

    public FileStorage(Path path) {
        this.dir = path;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return this.keyPath(key).thenApplyAsync(path -> Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]));
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return this.keyPath(prefix).thenApplyAsync(path -> {
            Collection<Object> keys;
            if (Files.exists(path, new LinkOption[0])) {
                int dirnamelen = Key.ROOT.string().equals(prefix.string()) ? path.toString().length() + 1 : path.toString().length() - prefix.string().length();
                try {
                    keys = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).map(p -> p.substring(dirnamelen)).map(s -> s.split(FileSystems.getDefault().getSeparator().replace("\\", "\\\\"))).map(Key.From::new).sorted(Comparator.comparing(Key.From::string)).collect(Collectors.toList());
                }
                catch (IOException iex) {
                    throw new ArtipieIOException(iex);
                }
            } else {
                keys = Collections.emptyList();
            }
            Logger.info((Object)this, (String)"Found %d objects by the prefix \"%s\" in %s by %s: %s", (Object[])new Object[]{keys.size(), prefix.string(), this.dir, path, keys});
            return keys;
        });
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return ((CompletableFuture)this.keyPath(key).thenApplyAsync(path -> {
            Path tmp = Paths.get(this.dir.toString(), String.format("%s.%s.tmp", key.string(), UUID.randomUUID()));
            tmp.getParent().toFile().mkdirs();
            return Pair.of((Object)path, (Object)tmp);
        })).thenCompose(pair -> (CompletionStage)pair.apply((path, tmp) -> new File(tmp).write(new OneTimePublisher<ByteBuffer>(content), new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING}).thenCompose(nothing -> FileStorage.move(tmp, path)).handleAsync((nothing, throwable) -> {
            tmp.toFile().delete();
            if (throwable == null) {
                return null;
            }
            throw new ArtipieIOException((Throwable)throwable);
        })));
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return ((CompletableFuture)this.keyPath(source).thenCompose(src -> this.keyPath(destination).thenApply(dst -> Pair.of((Object)src, (Object)dst)))).thenCompose(pair -> (CompletableFuture)pair.apply(FileStorage::move));
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.keyPath(key).thenAcceptAsync(path -> {
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                    this.deleteEmptyParts(path.getParent());
                }
                catch (IOException iex) {
                    throw new ArtipieIOException(iex);
                }
            } else {
                throw new ValueNotFoundException(key);
            }
        });
    }

    @Override
    public CompletableFuture<? extends Meta> metadata(Key key) {
        return this.keyPath(key).thenApplyAsync(path -> {
            BasicFileAttributes attrs;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (NoSuchFileException fex) {
                throw new ValueNotFoundException(key, (Throwable)fex);
            }
            catch (IOException iox) {
                throw new ArtipieIOException(iox);
            }
            return new FileMeta(attrs);
        });
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        Object res = Key.ROOT.string().equals(key.string()) ? new CompletableFutureSupport.Failed(new ArtipieIOException("Unable to load from root")).get() : ((CompletableFuture)((CompletableFuture)this.metadata(key).thenApply(meta -> (Long)((Optional)((Object)meta.read(Meta.OP_SIZE))).orElseThrow(() -> new ArtipieException(String.format("Size is not available for '%s' key", key.string()))))).thenCompose(size -> this.keyPath(key).thenApply(path -> Pair.of((Object)path, (Object)size)))).thenApply(pair -> (Content.OneTime)pair.apply((path, size) -> new Content.OneTime(new Content.From((long)size, (Publisher<ByteBuffer>)new File(path).content()))));
        return res;
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    private void deleteEmptyParts(Path target) {
        Path dirabs = this.dir.normalize().toAbsolutePath();
        Path path = target.normalize().toAbsolutePath();
        if (!path.toString().startsWith(dirabs.toString()) || dirabs.equals(path)) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean again = false;
            try {
                try (Stream<Path> files = Files.list(path);){
                    if (!files.findFirst().isPresent()) {
                        Files.deleteIfExists(path);
                        again = true;
                    }
                }
                if (again) {
                    this.deleteEmptyParts(path.getParent());
                }
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }

    private static CompletableFuture<Void> move(Path source, Path dest) {
        return CompletableFuture.supplyAsync(() -> {
            dest.getParent().toFile().mkdirs();
            return dest;
        }).thenAcceptAsync(dst -> {
            try {
                Files.move(source, dst, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iex) {
                throw new ArtipieIOException(iex);
            }
        });
    }

    private CompletableFuture<? extends Path> keyPath(Key key) {
        Path path = this.dir.resolve(key.string());
        CompletableFuture<Path> res = new CompletableFuture<Path>();
        if (path.normalize().startsWith(path)) {
            res.complete(path);
        } else {
            res.completeExceptionally(new ArtipieIOException(String.format("Entry path is out of storage: %s", key)));
        }
        return res;
    }
}

