/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.lock.storage;

import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.lock.Lock;
import com.artipie.asto.lock.storage.Proposals;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class StorageLock
implements Lock {
    private final Proposals proposals;
    private final String uuid;
    private final Optional<Instant> expiration;

    public StorageLock(Storage storage, Key target) {
        this(storage, target, UUID.randomUUID().toString(), Optional.empty());
    }

    public StorageLock(Storage storage, Key target, Instant expiration) {
        this(storage, target, UUID.randomUUID().toString(), Optional.of(expiration));
    }

    public StorageLock(Storage storage, Key target, String uuid, Optional<Instant> expiration) {
        this.proposals = new Proposals(storage, target);
        this.uuid = uuid;
        this.expiration = expiration;
    }

    @Override
    public CompletionStage<Void> acquire() {
        return this.proposals.create(this.uuid, this.expiration).thenCompose(nothing -> this.proposals.checkSingle(this.uuid)).handle((nothing, throwable) -> {
            CompletionStage<Void> result = throwable == null ? CompletableFuture.allOf(new CompletableFuture[0]) : this.release().thenCompose(released -> new FailedCompletionStage((Throwable)throwable));
            return result;
        }).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<Void> release() {
        return this.proposals.delete(this.uuid);
    }
}

