/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.misc;

import com.artipie.asto.ArtipieIOException;
import java.io.IOException;

public final class UncheckedRunnable
implements Runnable {
    private final CheckedRunnable<? extends Exception> original;

    public UncheckedRunnable(CheckedRunnable<? extends Exception> original) {
        this.original = original;
    }

    public static <E extends IOException> UncheckedRunnable newIoRunnable(CheckedRunnable<E> original) {
        return new UncheckedRunnable(original);
    }

    @Override
    public void run() {
        try {
            this.original.run();
        }
        catch (Exception err) {
            throw new ArtipieIOException(err);
        }
    }

    @FunctionalInterface
    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }
}

