/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Splitting;
import com.artipie.asto.s3.Bucket;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

final class MultipartUpload {
    private static final int MIN_PART_SIZE = 0x500000;
    private final Bucket bucket;
    private final Key key;
    private final String id;
    private final List<UploadedPart> parts;

    MultipartUpload(Bucket bucket, Key key, String id) {
        this.bucket = bucket;
        this.key = key;
        this.id = id;
        this.parts = new CopyOnWriteArrayList<UploadedPart>();
    }

    public CompletionStage<Void> upload(Content content) {
        AtomicInteger counter = new AtomicInteger();
        return ((CompletionStage)Flowable.fromPublisher((Publisher)content).concatMap(buffer -> Flowable.fromPublisher(new Splitting((ByteBuffer)buffer, 0x500000).publisher())).map(chunk -> {
            int pnum = counter.incrementAndGet();
            return this.uploadPart(pnum, (Publisher<ByteBuffer>)Flowable.just((Object)chunk)).thenAccept(response -> this.parts.add(new UploadedPart(pnum, response.eTag())));
        }).reduce(CompletableFuture.allOf(new CompletableFuture[0]), (acc, stage) -> acc.thenCompose(o -> stage)).to(SingleInterop.get())).thenCompose(Function.identity());
    }

    public CompletionStage<Void> complete() {
        return this.bucket.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().key(this.key.string()).uploadId(this.id).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts((Collection)this.parts.stream().sorted(Comparator.comparingInt(p -> ((UploadedPart)p).pnum)).map(UploadedPart::completedPart).collect(Collectors.toList())).build()).build()).thenApply(ignored -> null);
    }

    public CompletionStage<Void> abort() {
        return this.bucket.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().key(this.key.string()).uploadId(this.id).build()).thenApply(ignored -> null);
    }

    private CompletionStage<UploadPartResponse> uploadPart(int part, Publisher<ByteBuffer> content) {
        return ((CompletionStage)Observable.fromPublisher(content).reduce((Object)0L, (total, buf) -> total + (long)buf.remaining()).to(SingleInterop.get())).toCompletableFuture().thenCompose(length -> this.bucket.uploadPart((UploadPartRequest)UploadPartRequest.builder().key(this.key.string()).uploadId(this.id).partNumber(Integer.valueOf(part)).contentLength(length).build(), AsyncRequestBody.fromPublisher((Publisher)content)));
    }

    private static class UploadedPart {
        private final int pnum;
        private final String tag;

        UploadedPart(int pnum, String tag) {
            this.pnum = pnum;
            this.tag = tag;
        }

        CompletedPart completedPart() {
            return (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.pnum)).eTag(this.tag).build();
        }
    }
}

