/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.cache;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.cache.FromStorageCache;
import com.artipie.asto.cache.Remote;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class FromRemoteCache
implements Cache {
    private final Storage storage;

    public FromRemoteCache(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletionStage<Optional<? extends Content>> load(Key key, Remote remote, CacheControl control) {
        return remote.get().handle((content, throwable) -> {
            CompletionStage res;
            if (throwable == null && content.isPresent()) {
                res = ((CompletableFuture)this.storage.save(key, new Content.From(((Content)content.get()).size(), (Publisher<ByteBuffer>)((Publisher)content.get()))).thenCompose(nothing -> this.storage.value(key))).thenApply(Optional::of);
            } else {
                Throwable error = throwable == null ? new ArtipieIOException("Failed to load content from remote") : throwable;
                res = new FromStorageCache(this.storage).load(key, new Remote.Failed(error), control);
            }
            return res;
        }).thenCompose(Function.identity());
    }
}

