/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.ext;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;
import java.util.stream.Stream;

public enum Digests implements Supplier<MessageDigest>
{
    SHA256("SHA-256"),
    SHA1("SHA-1"),
    MD5("MD5"),
    SHA512("SHA-512");

    private final String name;

    private Digests(String name) {
        this.name = name;
    }

    @Override
    public MessageDigest get() {
        try {
            return MessageDigest.getInstance(this.name);
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException(String.format("No algorithm '%s'", this.name), err);
        }
    }

    public static final class FromString {
        private final String from;

        public FromString(String from) {
            this.from = from;
        }

        public Digests get() {
            return Stream.of(Digests.values()).filter(digest -> ((Digests)digest).name.equalsIgnoreCase(this.from)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported digest algorithm %s", this.from)));
        }
    }
}

