/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.OneTimePublisher;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.lock.storage.StorageLock;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cqfn.rio.file.File;
import org.reactivestreams.Publisher;

public final class FileStorage
implements Storage {
    private final Path dir;

    @Deprecated
    public FileStorage(Path path, Object nothing) {
        this(path);
    }

    public FileStorage(Path path) {
        this.dir = path;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            Path path = this.path(key);
            return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
        });
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return CompletableFuture.supplyAsync(() -> {
            Collection<Object> keys;
            Path path = this.path(prefix);
            if (Files.exists(path, new LinkOption[0])) {
                int dirnamelen = Key.ROOT.equals(prefix) ? path.toString().length() + 1 : path.toString().length() - prefix.string().length();
                try {
                    keys = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).map(p -> p.substring(dirnamelen)).map(s -> s.split(FileSystems.getDefault().getSeparator().replace("\\", "\\\\"))).map(Key.From::new).sorted(Comparator.comparing(Key.From::string)).collect(Collectors.toList());
                }
                catch (IOException iex) {
                    throw new ArtipieIOException(iex);
                }
            } else {
                keys = Collections.emptyList();
            }
            Logger.info((Object)this, (String)"Found %d objects by the prefix \"%s\" in %s by %s: %s", (Object[])new Object[]{keys.size(), prefix.string(), this.dir, path, keys});
            return keys;
        });
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return CompletableFuture.supplyAsync(() -> {
            Path tmp = Paths.get(this.dir.toString(), String.format("%s.%s.tmp", key.string(), UUID.randomUUID()));
            tmp.getParent().toFile().mkdirs();
            return tmp;
        }).thenCompose(tmp -> new File(tmp).write(new OneTimePublisher<ByteBuffer>(content), new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING}).thenCompose(nothing -> FileStorage.move(tmp, this.path(key))).handleAsync((nothing, throwable) -> {
            tmp.toFile().delete();
            CompletableFuture result = new CompletableFuture();
            if (throwable == null) {
                result.complete(null);
            } else {
                result.completeExceptionally(new ArtipieIOException((Throwable)throwable));
            }
            return result;
        }).thenCompose(Function.identity()));
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return FileStorage.move(this.path(source), this.path(destination));
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return CompletableFuture.runAsync(() -> {
            Path path = this.path(key);
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                    this.deleteEmptyParts(key.parent());
                }
                catch (IOException iex) {
                    throw new ArtipieIOException(iex);
                }
            } else {
                throw new ValueNotFoundException(key);
            }
        });
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Files.size(this.path(key));
            }
            catch (NoSuchFileException nofile) {
                throw new ValueNotFoundException(key, (Throwable)nofile);
            }
            catch (IOException iex) {
                throw new ArtipieIOException(iex);
            }
        });
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        Object res = Key.ROOT.equals(key) ? new CompletableFutureSupport.Failed(new ArtipieIOException("Unable to load from root")).get() : this.size(key).thenApply(size -> new Content.OneTime(new Content.From((long)size, (Publisher<ByteBuffer>)new File(this.path(key)).content())));
        return res;
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    private Path path(Key key) {
        return Paths.get(this.dir.toString(), key.string());
    }

    private void deleteEmptyParts(Optional<Key> key) {
        Path path;
        if (key.isPresent() && !key.get().string().isEmpty() && Files.isDirectory(path = this.path(key.get()), new LinkOption[0])) {
            boolean again = false;
            try {
                try (Stream<Path> files = Files.list(path);){
                    if (!files.findFirst().isPresent()) {
                        Files.deleteIfExists(path);
                        again = true;
                    }
                }
                if (again) {
                    this.deleteEmptyParts(key.get().parent());
                }
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }

    private static CompletableFuture<Void> move(Path source, Path dest) {
        return CompletableFuture.supplyAsync(() -> {
            dest.getParent().toFile().mkdirs();
            return dest;
        }).thenAcceptAsync(dst -> {
            try {
                Files.move(source, dst, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iex) {
                throw new ArtipieIOException(iex);
            }
        });
    }
}

