/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.memory;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.OneTimePublisher;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.memory.InMemoryStorage;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;

public final class BenchmarkStorage
implements Storage {
    private final InMemoryStorage backend;
    private final NavigableMap<Key, byte[]> local;
    private final Set<Key> deleted;

    public BenchmarkStorage(InMemoryStorage backend) {
        this.backend = backend;
        this.local = new ConcurrentSkipListMap<Key, byte[]>(Key.CMP_STRING);
        this.deleted = ConcurrentHashMap.newKeySet();
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return CompletableFuture.completedFuture(this.anyStorageContains(key) && !this.deleted.contains(key));
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key root) {
        return CompletableFuture.supplyAsync(() -> {
            Key key;
            String keystr;
            String prefix = root.string();
            TreeSet<Key> keys = new TreeSet<Key>(Key.CMP_STRING);
            SortedSet<String> bckndkeys = this.backend.data.navigableKeySet().tailSet(prefix);
            SortedSet<Key> lclkeys = this.local.navigableKeySet().tailSet(new Key.From(prefix));
            Iterator iterator = bckndkeys.iterator();
            while (iterator.hasNext() && (keystr = (String)iterator.next()).startsWith(prefix)) {
                if (this.deleted.contains(new Key.From(keystr))) continue;
                keys.add(new Key.From(keystr));
            }
            iterator = lclkeys.iterator();
            while (iterator.hasNext() && (key = (Key)iterator.next()).string().startsWith(prefix)) {
                if (this.deleted.contains(key)) continue;
                keys.add(key);
            }
            return keys;
        });
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        CompletableFuture<Void> res = Key.ROOT.equals(key) ? new CompletableFutureSupport.Failed(new ArtipieIOException("Unable to save to root")).get() : ((CompletionStage)new Concatenation(new OneTimePublisher<ByteBuffer>(content)).single().to(SingleInterop.get())).thenApply(Remaining::new).thenApply(Remaining::bytes).thenAccept(bytes -> this.local.put(key, (byte[])bytes)).thenAccept(noth -> this.deleted.remove(key)).toCompletableFuture();
        return res;
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        CompletionStage res;
        if (this.deleted.contains(source)) {
            res = BenchmarkStorage.ioErrorCompletion("No value for source key", source);
        } else {
            byte[] lcl = this.local.computeIfAbsent(source, key -> (byte[])this.backend.data.get(key.string()));
            if (lcl == null) {
                res = BenchmarkStorage.ioErrorCompletion("No value for source key", source);
            } else {
                this.local.put(destination, lcl);
                this.local.remove(source);
                this.deleted.remove(destination);
                res = CompletableFuture.allOf(new CompletableFuture[0]);
            }
        }
        return res.toCompletableFuture();
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        CompletionStage<Object> res = this.deleted.contains(key) || !this.anyStorageContains(key) ? BenchmarkStorage.notFoundCompletion(key) : (this.local.containsKey(key) ? CompletableFuture.completedFuture(Long.valueOf(((byte[])this.local.get(key)).length)) : CompletableFuture.completedFuture(Long.valueOf(((byte[])this.backend.data.get(key.string())).length)));
        return res.toCompletableFuture();
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        byte[] lcl;
        CompletionStage<Object> res = Key.ROOT.equals(key) ? new FailedCompletionStage(new ArtipieIOException("Unable to load from root")) : (this.deleted.contains(key) ? BenchmarkStorage.notFoundCompletion(key) : ((lcl = this.local.computeIfAbsent(key, ckey -> (byte[])this.backend.data.get(ckey.string()))) == null ? BenchmarkStorage.notFoundCompletion(key) : (this.deleted.contains(key) ? BenchmarkStorage.notFoundCompletion(key) : CompletableFuture.completedFuture(new Content.OneTime(new Content.From(lcl))))));
        return res.toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        boolean added;
        CompletionStage<Object> res = this.anyStorageContains(key) ? ((added = this.deleted.add(key)) ? CompletableFuture.allOf(new CompletableFuture[0]) : BenchmarkStorage.ioErrorCompletion("Key does not exist", key)) : BenchmarkStorage.ioErrorCompletion("Key does not exist", key);
        return res.toCompletableFuture();
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    private boolean anyStorageContains(Key key) {
        return this.local.containsKey(key) || this.backend.data.containsKey(key.string());
    }

    private static <T> CompletionStage<T> notFoundCompletion(Key key) {
        return new FailedCompletionStage(new ValueNotFoundException(key));
    }

    private static <T> CompletionStage<T> ioErrorCompletion(String msg, Key key) {
        return new FailedCompletionStage(new ArtipieIOException(String.format("%s: %s", msg, key.string())));
    }
}

