/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.blocking;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public class BlockingStorage {
    private final Storage storage;

    public BlockingStorage(Storage storage) {
        this.storage = storage;
    }

    public boolean exists(Key key) {
        return this.storage.exists(key).join();
    }

    public Collection<Key> list(Key prefix) {
        return this.storage.list(prefix).join();
    }

    public void save(Key key, byte[] content) {
        this.storage.save(key, new Content.From(content)).join();
    }

    public void move(Key source, Key destination) {
        this.storage.move(source, destination).join();
    }

    public long size(Key key) {
        return this.storage.size(key).join();
    }

    public byte[] value(Key key) {
        return new Remaining((ByteBuffer)((CompletableFuture)this.storage.value(key).thenApplyAsync(pub -> (ByteBuffer)new Concatenation((Publisher<ByteBuffer>)pub).single().blockingGet())).join(), true).bytes();
    }

    public void delete(Key key) {
        this.storage.delete(key).join();
    }
}

