/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.cache;

import com.artipie.asto.Key;
import com.artipie.asto.cache.Remote;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface CacheControl {
    public CompletionStage<Boolean> validate(Key var1, Remote var2);

    public static final class All
    implements CacheControl {
        private final Collection<CacheControl> items;

        public All(CacheControl ... items) {
            this(Arrays.asList(items));
        }

        public All(Collection<CacheControl> items) {
            this.items = items;
        }

        @Override
        public CompletionStage<Boolean> validate(Key key, Remote content) {
            return (CompletionStage)Observable.fromIterable(this.items).flatMapSingle(item -> SingleInterop.fromFuture(item.validate(key, content))).all(item -> item).to(SingleInterop.get());
        }
    }

    public static enum Standard implements CacheControl
    {
        NO_CACHE((item, content) -> CompletableFuture.completedFuture(false)),
        ALWAYS((item, content) -> CompletableFuture.completedFuture(true));

        private final CacheControl origin;

        private Standard(CacheControl origin) {
            this.origin = origin;
        }

        @Override
        public CompletionStage<Boolean> validate(Key item, Remote supplier) {
            return this.origin.validate(item, supplier);
        }
    }
}

