/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.etcd;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.ext.PublisherAs;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.options.GetOption;
import io.vavr.NotImplementedError;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class EtcdStorage
implements Storage {
    private static final long MAX_SIZE = 0xA00000L;
    private final Client client;

    public EtcdStorage(Client client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return this.client.getKVClient().get(EtcdStorage.keyToSeq(key), GetOption.newBuilder().withCountOnly(true).build()).thenApply(rsp -> rsp.getCount() > 0L);
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return this.client.getKVClient().get(EtcdStorage.keyToSeq(prefix), GetOption.newBuilder().withKeysOnly(true).withSortOrder(GetOption.SortOrder.ASCEND).build()).thenApply(rsp -> rsp.getKvs().stream().map(kv -> new String(kv.getKey().getBytes(), StandardCharsets.UTF_8)).map(str -> new Key.From((String)str)).distinct().collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        long size = content.size().orElse(0L);
        if (size <= 0L || size > 0xA00000L) {
            return new CompletableFutureSupport.Failed(new ArtipieIOException(String.format("Content size must be in range (1;%d)", 0xA00000L))).get();
        }
        return new PublisherAs(content).bytes().thenApply(ByteSequence::from).thenCompose(data -> this.client.getKVClient().put(EtcdStorage.keyToSeq(key), data)).thenApply(ignore -> null).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return ((CompletableFuture)this.value(source).thenCompose(data -> this.save(destination, (Content)data))).thenCompose(none -> this.delete(source));
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return ((CompletableFuture)((CompletableFuture)this.client.getKVClient().get(EtcdStorage.keyToSeq(key)).thenApply(rsp -> rsp.getKvs().stream().max((left, right) -> Long.compare(left.getVersion(), right.getVersion())))).thenApply(kv -> ((KeyValue)kv.orElseThrow(() -> new ValueNotFoundException(key))).getValue().getBytes())).thenApply(bytes -> ((byte[])bytes).length);
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return ((CompletableFuture)((CompletableFuture)this.client.getKVClient().get(EtcdStorage.keyToSeq(key)).thenApply(rsp -> rsp.getKvs().stream().max((left, right) -> Long.compare(left.getVersion(), right.getVersion())))).thenApply(kv -> ((KeyValue)kv.orElseThrow(() -> new ValueNotFoundException(key))).getValue().getBytes())).thenApply(bytes -> new Content.From((byte[])bytes));
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.client.getKVClient().delete(EtcdStorage.keyToSeq(key)).thenAccept(rsp -> {
            if (rsp.getDeleted() == 0L) {
                throw new ValueNotFoundException(key);
            }
        });
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        throw new NotImplementedError("size not implemented");
    }

    private static ByteSequence keyToSeq(Key key) {
        return ByteSequence.from((String)key.string(), (Charset)StandardCharsets.UTF_8);
    }
}

