/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.s3.Bucket;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import hu.akarnokd.rxjava2.operators.FlowableTransformers;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.functions.Predicate;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

final class MultipartUpload {
    private static final long MIN_PART_SIZE = 0x500000L;
    private final Bucket bucket;
    private final Key key;
    private final String id;

    MultipartUpload(Bucket bucket, Key key, String id) {
        this.bucket = bucket;
        this.key = key;
        this.id = id;
    }

    public CompletionStage<Void> upload(Content content) {
        AtomicInteger part = new AtomicInteger();
        return ((CompletionStage)Flowable.fromPublisher((Publisher)content).compose(FlowableTransformers.bufferWhile((Predicate)new Predicate<ByteBuffer>(){
            private long sum;

            public boolean test(ByteBuffer buffer) {
                boolean keep;
                int length = buffer.remaining();
                if (this.sum + (long)length > 0x500000L) {
                    this.sum = length;
                    keep = false;
                } else {
                    this.sum += (long)length;
                    keep = true;
                }
                return keep;
            }
        })).map(chunk -> this.uploadPart(part.incrementAndGet(), (Publisher<ByteBuffer>)Flowable.fromIterable((Iterable)chunk)).thenApply(ignored -> null)).reduce(CompletableFuture.allOf(new CompletableFuture[0]), (acc, stage) -> acc.thenCompose(o -> stage)).to(SingleInterop.get())).toCompletableFuture().thenCompose(Function.identity());
    }

    public CompletionStage<Void> complete() {
        return this.bucket.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().key(this.key.string()).uploadId(this.id).build()).thenApply(ignored -> null);
    }

    public CompletionStage<Void> abort() {
        return this.bucket.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().key(this.key.string()).uploadId(this.id).build()).thenApply(ignored -> null);
    }

    private CompletionStage<UploadPartResponse> uploadPart(int part, Publisher<ByteBuffer> content) {
        return ((CompletionStage)Observable.fromPublisher(content).reduce((Object)0L, (total, buf) -> total + (long)buf.remaining()).to(SingleInterop.get())).toCompletableFuture().thenCompose(length -> this.bucket.uploadPart((UploadPartRequest)UploadPartRequest.builder().key(this.key.string()).uploadId(this.id).partNumber(Integer.valueOf(part)).contentLength(length).build(), AsyncRequestBody.fromPublisher((Publisher)content)));
    }
}

