/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.test;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class TestResource {
    private final String name;

    public TestResource(String name) {
        this.name = name;
    }

    public void saveTo(Storage storage, Key key) {
        storage.save(key, new Content.From(this.asBytes())).join();
    }

    public void saveTo(Storage storage) {
        this.saveTo(storage, new Key.From(this.name));
    }

    public void saveTo(Path path) throws IOException {
        Files.write(path, this.asBytes(), new OpenOption[0]);
    }

    public void addFilesTo(Storage storage, Key base) {
        FileStorage resources = new FileStorage(this.asPath());
        ((CompletableFuture)resources.list(Key.ROOT).thenCompose(keys -> CompletableFuture.allOf((CompletableFuture[])keys.stream().map(Key::string).map(item -> resources.value(new Key.From((String)item)).thenCompose(content -> storage.save(new Key.From(base, (String)item), (Content)content))).toArray(CompletableFuture[]::new)))).join();
    }

    public Path asPath() {
        try {
            return Paths.get(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(this.name)).toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Failed to obtain test recourse", ex);
        }
    }

    public InputStream asInputStream() {
        return Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.name));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] asBytes() {
        try (InputStream stream = this.asInputStream();){
            int count;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((count = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, count);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load test recourse", ex);
        }
    }
}

