/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.composer.Name;
import com.artipie.composer.Package;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;

public final class JsonPackage
implements Package {
    private final ByteSource content;

    public JsonPackage(ByteSource content) {
        this.content = content;
    }

    @Override
    public Name name() throws IOException {
        return new Name(this.mandatoryString("name"));
    }

    @Override
    public String version() throws IOException {
        return this.mandatoryString("version");
    }

    @Override
    public JsonObject json() throws IOException {
        try (JsonReader reader = Json.createReader((InputStream)this.content.openStream());){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    private String mandatoryString(String name) throws IOException {
        JsonString string = this.json().getJsonString(name);
        if (string == null) {
            throw new IllegalStateException(String.format("Bad package, no '%s' found.", name));
        }
        return string.getString();
    }
}

