/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.blocking.BlockingStorage;
import com.artipie.composer.Package;
import com.artipie.composer.Packages;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public final class JsonPackages
implements Packages {
    private static final String ATTRIBUTE = "packages";
    private final ByteSource content;

    public JsonPackages() {
        this(JsonPackages.bytes(Json.createObjectBuilder().add(ATTRIBUTE, Json.createObjectBuilder()).build()));
    }

    public JsonPackages(ByteSource content) {
        this.content = content;
    }

    @Override
    public Packages add(Package pack) throws IOException {
        JsonObject json = this.json();
        if (json.isNull(ATTRIBUTE)) {
            throw new IllegalStateException("Bad content, no 'packages' object found");
        }
        JsonObject packages = json.getJsonObject(ATTRIBUTE);
        String pname = pack.name().string();
        JsonObjectBuilder builder = packages.isEmpty() || packages.isNull(pname) ? Json.createObjectBuilder() : Json.createObjectBuilder((JsonObject)packages.getJsonObject(pname));
        builder.add(pack.version(), (JsonValue)pack.json());
        return new JsonPackages(JsonPackages.bytes(Json.createObjectBuilder((JsonObject)json).add(ATTRIBUTE, Json.createObjectBuilder((JsonObject)packages).add(pname, builder)).build()));
    }

    @Override
    public CompletableFuture<Void> save(Storage storage, Key key) {
        return CompletableFuture.runAsync(() -> this.save(new BlockingStorage(storage), key));
    }

    private void save(BlockingStorage storage, Key key) {
        byte[] bytes;
        try {
            bytes = this.content.read();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read content", ex);
        }
        storage.save(key, bytes);
    }

    private JsonObject json() throws IOException {
        try (JsonReader reader = Json.createReader((InputStream)this.content.openStream());){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ByteSource bytes(JsonObject json) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ByteSource byteSource;
            block13: {
                JsonWriter writer = Json.createWriter((OutputStream)out);
                try {
                    writer.writeObject(json);
                    out.flush();
                    byteSource = ByteSource.wrap((byte[])out.toByteArray());
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return byteSource;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to serialize JSON to bytes", ex);
        }
    }
}

