/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.blocking.BlockingStorage;
import com.artipie.composer.AllPackages;
import com.artipie.composer.JsonPackage;
import com.artipie.composer.JsonPackages;
import com.artipie.composer.Name;
import com.artipie.composer.Packages;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class Repository {
    public static final Key ALL_PACKAGES = new AllPackages();
    private final Storage storage;

    public Repository(Storage storage) {
        this.storage = storage;
    }

    public Packages packages() {
        return this.packages(ALL_PACKAGES);
    }

    public Packages packages(Name name) {
        return this.packages(name.key());
    }

    public CompletableFuture<Void> add(Key key) throws IOException {
        ByteSource content = ByteSource.wrap((byte[])new BlockingStorage(this.storage).value(key));
        JsonPackage pack = new JsonPackage(content);
        Name name = pack.name();
        return CompletableFuture.allOf(this.packages().add(pack).save(this.storage, ALL_PACKAGES), this.packages(name).add(pack).save(this.storage, name.key()));
    }

    private Packages packages(Key key) {
        JsonPackages packages;
        BlockingStorage blocking = new BlockingStorage(this.storage);
        if (blocking.exists(key)) {
            ByteSource content = ByteSource.wrap((byte[])blocking.value(key));
            packages = new JsonPackages(content);
        } else {
            packages = new JsonPackages();
        }
        return packages;
    }
}

