/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.composer.AllPackages;
import com.artipie.composer.Name;
import com.artipie.composer.http.Resource;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class PackageMetadata
implements Resource {
    public static final Key ALL_PACKAGES = new AllPackages();
    private static final Pattern PATH_PATTERN = Pattern.compile("/p/(?<vendor>[^/]+)/(?<package>[^/]+)\\.json$");
    private final String path;
    private final Storage storage;

    public PackageMetadata(String path, Storage storage) {
        this.path = path;
        this.storage = storage;
    }

    @Override
    public Response put(Publisher<ByteBuffer> body) {
        return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
    }

    @Override
    public Response get() {
        return connection -> CompletableFuture.supplyAsync(this::key).thenCompose(key -> this.storage.exists(key).thenCompose(exists -> {
            CompletionStage sent = exists != false ? this.storage.value(key).thenCompose(data -> connection.accept(RsStatus.OK, Collections.emptyList(), (Publisher)data)) : new RsWithStatus(RsStatus.NOT_FOUND).send(connection);
            return sent;
        }));
    }

    private Key key() {
        Key key;
        Matcher matcher = PATH_PATTERN.matcher(this.path);
        if (matcher.find()) {
            key = new Name(String.format("%s/%s", matcher.group("vendor"), matcher.group("package"))).key();
        } else if (this.path.equals(String.format("/%s", ALL_PACKAGES.string()))) {
            key = ALL_PACKAGES;
        } else {
            throw new IllegalStateException(String.format("Unexpected path: %s", this.path));
        }
        return key;
    }
}

