/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http;

import com.artipie.asto.Storage;
import com.artipie.composer.http.PackageMetadata;
import com.artipie.composer.http.Resource;
import com.artipie.composer.http.Root;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class PhpComposer
implements Slice {
    private final String base;
    private final Storage storage;

    public PhpComposer(String base, Storage storage) {
        this.base = base;
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Object response;
        RequestLineFrom request = new RequestLineFrom(line);
        String path = request.uri().getPath();
        if (path.startsWith(this.base)) {
            Resource resource = this.resource(path.substring(this.base.length()));
            RqMethod method = request.method();
            response = method.equals((Object)RqMethod.GET) ? resource.get() : (method.equals((Object)RqMethod.PUT) ? resource.put(body) : new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED));
        } else {
            response = new RsWithStatus(RsStatus.NOT_FOUND);
        }
        return response;
    }

    private Resource resource(String path) {
        Resource resource = path.isEmpty() ? new Root(this.storage) : new PackageMetadata(path, this.storage);
        return resource;
    }
}

