/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.composer.Name;
import com.artipie.composer.Package;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;

public final class JsonPackage
implements Package {
    private final ByteSource content;

    public JsonPackage(ByteSource content) {
        this.content = content;
    }

    @Override
    public Name name() {
        return new Name(this.mandatoryString("name"));
    }

    @Override
    public String version() {
        return this.mandatoryString("version");
    }

    @Override
    public JsonObject json() {
        JsonObject jsonObject;
        block8: {
            JsonReader reader = Json.createReader((InputStream)this.content.openStream());
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private String mandatoryString(String name) {
        JsonString string = this.json().getJsonString(name);
        if (string == null) {
            throw new IllegalStateException(String.format("Bad package, no '%s' found.", name));
        }
        return string.getString();
    }
}

