/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.composer.Package;
import com.artipie.composer.Packages;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public final class JsonPackages
implements Packages {
    private static final String ATTRIBUTE = "packages";
    private final ByteSource source;

    public JsonPackages() {
        this(JsonPackages.bytes(Json.createObjectBuilder().add(ATTRIBUTE, Json.createObjectBuilder()).build()));
    }

    public JsonPackages(ByteSource source) {
        this.source = source;
    }

    @Override
    public Packages add(Package pack) {
        JsonObject json = this.json();
        if (json.isNull(ATTRIBUTE)) {
            throw new IllegalStateException("Bad content, no 'packages' object found");
        }
        JsonObject packages = json.getJsonObject(ATTRIBUTE);
        String pname = pack.name().string();
        JsonObjectBuilder builder = packages.isEmpty() || packages.isNull(pname) ? Json.createObjectBuilder() : Json.createObjectBuilder((JsonObject)packages.getJsonObject(pname));
        builder.add(pack.version(), (JsonValue)pack.json());
        return new JsonPackages(JsonPackages.bytes(Json.createObjectBuilder((JsonObject)json).add(ATTRIBUTE, Json.createObjectBuilder((JsonObject)packages).add(pname, builder)).build()));
    }

    @Override
    public CompletableFuture<Void> save(Storage storage, Key key) {
        return storage.save(key, this.content());
    }

    @Override
    public Content content() {
        byte[] bytes;
        try {
            bytes = this.source.read();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read content", ex);
        }
        return new Content.From(bytes);
    }

    private JsonObject json() {
        JsonObject jsonObject;
        block8: {
            JsonReader reader = Json.createReader((InputStream)this.source.openStream());
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ByteSource bytes(JsonObject json) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ByteSource byteSource;
            block13: {
                JsonWriter writer = Json.createWriter((OutputStream)out);
                try {
                    writer.writeObject(json);
                    out.flush();
                    byteSource = ByteSource.wrap((byte[])out.toByteArray());
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return byteSource;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to serialize JSON to bytes", ex);
        }
    }
}

