/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http;

import com.artipie.composer.Name;
import com.artipie.composer.Packages;
import com.artipie.composer.Repository;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class PackageMetadataSlice
implements Slice {
    public static final Pattern PACKAGE = Pattern.compile("/p/(?<vendor>[^/]+)/(?<package>[^/]+)\\.json$");
    public static final Pattern ALL_PACKAGES = Pattern.compile("^/packages.json$");
    private final Repository repository;

    public PackageMetadataSlice(Repository repository) {
        this.repository = repository;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(this.packages(new RequestLineFrom(line).uri().getPath()).thenApply(opt -> opt.map(packages -> new RsWithBody((Publisher)packages.content())).orElse((Response)new RsWithStatus(RsStatus.NOT_FOUND))));
    }

    private CompletionStage<Optional<Packages>> packages(String path) {
        CompletionStage<Optional<Packages>> result;
        Matcher matcher = PACKAGE.matcher(path);
        if (matcher.find()) {
            result = this.repository.packages(new Name(String.format("%s/%s", matcher.group("vendor"), matcher.group("package"))));
        } else if (ALL_PACKAGES.matcher(path).matches()) {
            result = this.repository.packages();
        } else {
            throw new IllegalStateException(String.format("Unexpected path: %s", path));
        }
        return result;
    }
}

