/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.composer.Name;
import com.artipie.composer.Package;
import com.artipie.composer.Packages;
import com.artipie.composer.misc.ContentAsJson;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public final class JsonPackages
implements Packages {
    private static final String ATTRIBUTE = "packages";
    private final Content source;

    public JsonPackages() {
        this(JsonPackages.toContent(Json.createObjectBuilder().add(ATTRIBUTE, Json.createObjectBuilder()).build()));
    }

    public JsonPackages(Content source) {
        this.source = source;
    }

    @Override
    public CompletionStage<Packages> add(Package pack, Optional<String> vers) {
        return new ContentAsJson(this.source).value().thenCompose(json -> {
            if (json.isNull(ATTRIBUTE)) {
                throw new IllegalStateException("Bad content, no 'packages' object found");
            }
            JsonObject pkgs = json.getJsonObject(ATTRIBUTE);
            return pack.name().thenApply(Name::string).thenCompose(pname -> {
                JsonObjectBuilder builder = pkgs.isEmpty() || pkgs.isNull(pname) ? Json.createObjectBuilder() : Json.createObjectBuilder((JsonObject)pkgs.getJsonObject(pname));
                return pack.version(vers).thenCombine(pack.json(), (vrsn, pkg) -> {
                    if (!vrsn.isPresent()) {
                        throw new IllegalStateException(String.format("Failed to add package `%s` to packages.json because version is absent", pname));
                    }
                    JsonObject foradd = pkg.containsKey((Object)"version") ? pkg : Json.createObjectBuilder((JsonObject)pkg).add("version", (String)vrsn.get()).build();
                    return builder.add((String)vrsn.get(), (JsonValue)foradd);
                }).thenApply(bldr -> new JsonPackages(JsonPackages.toContent(Json.createObjectBuilder((JsonObject)json).add(ATTRIBUTE, Json.createObjectBuilder((JsonObject)pkgs).add(pname, bldr)).build())));
            });
        });
    }

    @Override
    public CompletionStage<Void> save(Storage storage, Key key) {
        return this.content().thenCompose(content -> storage.save(key, content));
    }

    @Override
    public CompletionStage<Content> content() {
        return CompletableFuture.completedFuture(this.source);
    }

    private static Content toContent(JsonObject json) {
        return new Content.From(json.toString().getBytes(StandardCharsets.UTF_8));
    }
}

