/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http;

import com.artipie.asto.Content;
import com.artipie.composer.Repository;
import com.artipie.composer.http.Archive;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class AddArchiveSlice
implements Slice {
    public static final Pattern PATH = Pattern.compile("^/(?<full>(?<name>[a-z0-9_.\\-]*)-(?<version>v?\\d+.\\d+.\\d+[-\\w]*).zip)$");
    private final Repository repository;

    AddArchiveSlice(Repository repository) {
        this.repository = repository;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom rqline = new RequestLineFrom(line);
        String uri = rqline.uri().getPath();
        Matcher matcher = PATH.matcher(uri);
        Object resp = matcher.matches() ? new AsyncResponse(this.repository.addArchive(new Archive.Zip(new Archive.Name(matcher.group("full"), matcher.group("version"))), (Content)new Content.From(body)).thenApply(nothing -> new RsWithStatus(RsStatus.CREATED))) : new RsWithStatus(RsStatus.BAD_REQUEST);
        return resp;
    }
}

