/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public interface Archive {
    public CompletionStage<JsonObject> composerFrom(Content var1);

    public CompletionStage<Content> replaceComposerWith(Content var1, byte[] var2);

    public Name name();

    public static class Name {
        private final String full;
        private final String vrsn;

        public Name(String full, String vrsn) {
            this.full = full;
            this.vrsn = vrsn;
        }

        public String full() {
            return this.full;
        }

        public String version() {
            return this.vrsn;
        }
    }

    public static class Zip
    implements Archive {
        private static final String COMPOS = "composer.json";
        private final Name cname;

        public Zip(Name name) {
            this.cname = name;
        }

        @Override
        public CompletionStage<JsonObject> composerFrom(Content archive) {
            return new PublisherAs(archive).bytes().thenApply(bytes -> {
                try (ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)new ByteArrayInputStream((byte[])bytes));){
                    ZipArchiveEntry entry;
                    while ((entry = zip.getNextZipEntry()) != null) {
                        String[] parts = entry.getName().split("/");
                        if (!parts[parts.length - 1].equals(COMPOS)) continue;
                        JsonObject jsonObject = Json.createReader((InputStream)zip).readObject();
                        return jsonObject;
                    }
                    throw new IllegalStateException(String.format("'%s' file was not found", COMPOS));
                }
                catch (IOException exc) {
                    throw new UncheckedIOException(exc);
                }
            });
        }

        @Override
        public Name name() {
            return this.cname;
        }

        @Override
        public CompletionStage<Content> replaceComposerWith(Content archive, byte[] composer) {
            return new PublisherAs(archive).bytes().thenApply(bytes -> {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(bos);
                try {
                    try (ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)new ByteArrayInputStream((byte[])bytes));){
                        ZipArchiveEntry entry;
                        while ((entry = zip.getNextZipEntry()) != null) {
                            ZipEntry newentr = new ZipEntry(entry.getName());
                            boolean isdir = newentr.isDirectory();
                            String[] parts = entry.getName().split("/");
                            if (parts[parts.length - 1].equals(COMPOS) && !isdir) {
                                zos.putNextEntry(newentr);
                                zos.write(composer);
                            } else if (!isdir) {
                                int len;
                                zos.putNextEntry(newentr);
                                byte[] buf = new byte[1024];
                                while ((len = zip.read(buf)) > 0) {
                                    zos.write(buf, 0, len);
                                }
                            }
                            zos.flush();
                            zos.closeEntry();
                        }
                    }
                    finally {
                        zos.close();
                    }
                }
                catch (IOException exc) {
                    throw new UncheckedIOException(exc);
                }
                return bos.toByteArray();
            }).thenApply(Content.From::new);
        }
    }
}

