/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http.proxy;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.cache.Remote;
import com.artipie.composer.misc.ContentAsJson;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class CacheTimeControl
implements CacheControl {
    static final Key CACHE_FILE = new Key.From("cache/cache-info.json");
    private final Duration expiration;
    private final Storage storage;

    CacheTimeControl(Storage storage) {
        this(storage, Duration.ofMinutes(10L));
    }

    CacheTimeControl(Storage storage, Duration expiration) {
        this.storage = storage;
        this.expiration = expiration;
    }

    public CompletionStage<Boolean> validate(Key item, Remote content) {
        return this.storage.exists(CACHE_FILE).thenCompose(exists -> {
            CompletionStage<Boolean> res = exists != false ? ((CompletableFuture)((CompletableFuture)this.storage.value(CACHE_FILE).thenApply(ContentAsJson::new)).thenCompose(ContentAsJson::value)).thenApply(json -> {
                String key = item.string();
                return json.containsKey((Object)key) && this.notExpired(json.getString(key));
            }) : CompletableFuture.completedFuture(false);
            return res;
        });
    }

    private boolean notExpired(String time) {
        return !Duration.between(Instant.now().atZone(ZoneOffset.UTC), ZonedDateTime.parse(time)).plus(this.expiration).isNegative();
    }
}

