/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http.proxy;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.cache.Remote;
import com.artipie.composer.JsonPackages;
import com.artipie.composer.Packages;
import com.artipie.composer.Repository;
import com.artipie.composer.http.proxy.CacheTimeControl;
import com.artipie.composer.http.proxy.MergePackage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.StandardRs;
import com.jcabi.log.Logger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;

final class CachedProxySlice
implements Slice {
    private final Slice remote;
    private final Cache cache;
    private final Repository repo;

    CachedProxySlice(Slice remote, Repository repo) {
        this(remote, repo, Cache.NOP);
    }

    CachedProxySlice(Slice remote, Repository repo, Cache cache) {
        this.remote = remote;
        this.cache = cache;
        this.repo = repo;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        String name = new RequestLineFrom(line).uri().getPath().replaceAll("^/p2?/", "").replaceAll("~.*", "").replaceAll("\\^.*", "").replaceAll(".json$", "");
        return new AsyncResponse(this.cache.load((Key)new Key.From(name), (Remote)new Remote.WithErrorHandling(() -> this.repo.packages().thenApply(pckgs -> pckgs.orElse(new JsonPackages())).thenCompose(Packages::content).thenCombine(this.packageFromRemote(line), (lcl, rmt) -> new MergePackage.WithRemote(name, (Content)lcl).merge((Optional<? extends Content>)rmt)).thenCompose(Function.identity()).thenApply(Function.identity())), (CacheControl)new CacheTimeControl(this.repo.storage())).handle((pkgs, throwable) -> {
            RsWithBody res;
            if (throwable == null && pkgs.isPresent()) {
                res = new RsWithBody((Response)StandardRs.OK, (Content)pkgs.get());
            } else {
                Logger.warn((Object)this, (String)"Failed to read cached item: %[exception]s", (Object[])new Object[]{throwable});
                res = StandardRs.NOT_FOUND;
            }
            return res;
        }));
    }

    private CompletionStage<Optional<? extends Content>> packageFromRemote(String line) {
        return new Remote.WithErrorHandling(() -> {
            CompletableFuture promise = new CompletableFuture();
            this.remote.response(line, (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY).send((rsstatus, rsheaders, rsbody) -> {
                if (rsstatus.success()) {
                    promise.complete(Optional.of(new Content.From(rsbody)));
                } else {
                    promise.complete(Optional.empty());
                }
                return CompletableFuture.allOf(new CompletableFuture[0]);
            });
            return promise;
        }).get();
    }
}

