/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http.proxy;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.cache.Remote;
import com.artipie.composer.Repository;
import com.artipie.composer.http.proxy.CacheTimeControl;
import com.artipie.composer.misc.ContentAsJson;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonObject;

public final class ComposerStorageCache
implements Cache {
    static final String CACHE_FOLDER = "cache";
    private final Repository repo;

    public ComposerStorageCache(Repository repository) {
        this.repo = repository;
    }

    public CompletionStage<Optional<? extends Content>> load(Key name, Remote remote, CacheControl control) {
        Key.From cached = new Key.From(new String[]{CACHE_FOLDER, String.format("%s.json", name.string())});
        return this.repo.exists((Key)cached).thenCompose(arg_0 -> this.lambda$load$3(control, name, (Key)cached, remote, arg_0));
    }

    private CompletableFuture<Optional<? extends Content>> contentFromRemote(Remote remote, Key cached, Key name) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null).thenCombine(remote.get(), (nothing, content) -> {
            CompletionStage res = content.isPresent() ? ((CompletableFuture)((CompletableFuture)this.repo.save(cached, (Content)content.get()).thenCompose(noth -> this.updateCacheFile(cached, name))).thenCompose(ignore -> this.repo.value(cached))).thenApply(Optional::of) : CompletableFuture.completedFuture(Optional.empty());
            return res;
        })).thenCompose(Function.identity());
    }

    private CompletionStage<Void> updateCacheFile(Key cached, Key name) {
        Key.From tmp = new Key.From(String.format("%s%s.json", cached, UUID.randomUUID().toString()));
        return ((CompletableFuture)this.repo.exists(CacheTimeControl.CACHE_FILE).thenCompose(this::createCacheFileIfAbsent)).thenCompose(arg_0 -> this.lambda$updateCacheFile$13(name, (Key)tmp, arg_0));
    }

    private CompletionStage<Void> createCacheFileIfAbsent(boolean exists) {
        CompletableFuture<Void> res = exists ? CompletableFuture.allOf(new CompletableFuture[0]) : this.repo.save(CacheTimeControl.CACHE_FILE, (Content)new Content.From(Json.createObjectBuilder().build().toString().getBytes()));
        return res;
    }

    private static byte[] addTimeFor(JsonObject json, Key name) {
        return Json.createObjectBuilder((JsonObject)json).add(name.string(), ZonedDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).toString()).build().toString().getBytes();
    }

    private /* synthetic */ CompletionStage lambda$updateCacheFile$13(Key name, Key tmp, Void nothing) {
        return this.repo.exclusively(CacheTimeControl.CACHE_FILE, nthng -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.repo.value(CacheTimeControl.CACHE_FILE).thenApply(ContentAsJson::new)).thenCompose(ContentAsJson::value)).thenApply(json -> ComposerStorageCache.addTimeFor(json, name))).thenCompose(json -> this.repo.save(tmp, (Content)new Content.From(json)))).thenCompose(noth -> this.repo.delete(CacheTimeControl.CACHE_FILE))).thenCompose(noth -> this.repo.move(tmp, CacheTimeControl.CACHE_FILE)));
    }

    private /* synthetic */ CompletionStage lambda$load$3(CacheControl control, Key name, Key cached, Remote remote, Boolean exists) {
        CompletionStage<Optional<Object>> res = exists != false ? control.validate(name, () -> CompletableFuture.completedFuture(Optional.empty())).thenCompose(valid -> {
            CompletionStage cacheval = valid != false ? this.repo.value(cached).thenApply(Optional::of) : CompletableFuture.completedFuture(Optional.empty());
            return cacheval;
        }).thenCompose(cacheres -> {
            CompletableFuture<Optional> rmtorcache = cacheres.isPresent() ? CompletableFuture.completedFuture(cacheres) : this.contentFromRemote(remote, cached, name);
            return rmtorcache;
        }) : this.contentFromRemote(remote, cached, name);
        return res;
    }
}

