/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.asto.Content;
import com.artipie.composer.Name;
import com.artipie.composer.Package;
import com.artipie.composer.misc.ContentAsJson;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.json.JsonObject;

public final class JsonPackage
implements Package {
    public static final String VRSN = "version";
    private final Content content;

    public JsonPackage(Content content) {
        this.content = content;
    }

    @Override
    public CompletionStage<Name> name() {
        return this.mandatoryString("name").thenApply(Name::new);
    }

    @Override
    public CompletionStage<Optional<String>> version(Optional<String> value) {
        String version = value.orElse(null);
        return this.optString(VRSN).thenApply(opt -> opt.orElse(version)).thenApply(Optional::ofNullable);
    }

    @Override
    public CompletionStage<JsonObject> json() {
        return new ContentAsJson(this.content).value();
    }

    private CompletionStage<String> mandatoryString(String name) {
        return this.json().thenApply(jsn -> jsn.getString(name)).thenCompose(val -> {
            CompletionStage<String> res = val == null ? new CompletableFuture().exceptionally(ignore -> {
                throw new IllegalStateException(String.format("Bad package, no '%s' found.", name));
            }) : CompletableFuture.completedFuture(val);
            return res;
        });
    }

    private CompletionStage<Optional<String>> optString(String name) {
        return this.json().thenApply(json -> json.getString(name, null)).thenApply(Optional::ofNullable);
    }
}

