/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer.http.proxy;

import com.artipie.asto.Content;
import com.artipie.composer.misc.ContentAsJson;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public interface MergePackage {
    public CompletionStage<Optional<Content>> merge(Optional<? extends Content> var1);

    public static class WithRemote
    implements MergePackage {
        private final String name;
        private final Content local;

        WithRemote(String name, Content local) {
            this.name = name;
            this.local = local;
        }

        @Override
        public CompletionStage<Optional<Content>> merge(Optional<? extends Content> remote) {
            return WithRemote.packagesFrom(this.local).thenApply(this::packageByNameFrom).thenCombine(WithRemote.packagesFromOpt(remote), (lcl, rmt) -> {
                JsonObject builded = this.jsonWithMergedContent((JsonObject)lcl, (Optional<JsonObject>)rmt);
                Optional<Object> res = builded.keySet().isEmpty() ? Optional.empty() : Optional.of(new Content.From(Json.createObjectBuilder().add("packages", (JsonValue)Json.createObjectBuilder().add(this.name, (JsonValue)builded).build()).build().toString().getBytes(StandardCharsets.UTF_8)));
                return res;
            });
        }

        private static CompletionStage<Optional<JsonObject>> packagesFrom(Content pkgs) {
            return new ContentAsJson(pkgs).value().thenApply(json -> json.getJsonObject("packages")).thenApply(Optional::ofNullable);
        }

        private static CompletionStage<Optional<JsonObject>> packagesFromOpt(Optional<? extends Content> pkgs) {
            CompletionStage<Optional<JsonObject>> res = pkgs.isPresent() ? WithRemote.packagesFrom(pkgs.get()) : CompletableFuture.completedFuture(Optional.empty());
            return res;
        }

        private JsonObject packageByNameFrom(Optional<JsonObject> json) {
            JsonObject res = json.isPresent() && json.get().containsKey((Object)this.name) ? json.get().getJsonObject(this.name) : Json.createObjectBuilder().build();
            return res;
        }

        private JsonObject jsonWithMergedContent(JsonObject lcl, Optional<JsonObject> rmt) {
            Set vrsns = lcl.keySet();
            JsonObjectBuilder bldr = Json.createObjectBuilder();
            vrsns.forEach(vers -> bldr.add(vers, (JsonValue)Json.createObjectBuilder((JsonObject)lcl.getJsonObject(vers)).add("uid", UUID.randomUUID().toString()).build()));
            if (rmt.isPresent() && rmt.get().containsKey((Object)this.name)) {
                rmt.get().getJsonArray(this.name).stream().map(JsonValue::asJsonObject).forEach(entry -> {
                    String vers = entry.getString("version");
                    if (!vrsns.contains(vers)) {
                        JsonObjectBuilder rmtblbdr = Json.createObjectBuilder((JsonObject)entry);
                        if (!entry.containsKey((Object)"name")) {
                            rmtblbdr.add("name", this.name);
                        }
                        rmtblbdr.add("uid", UUID.randomUUID().toString());
                        bldr.add(vers, (JsonValue)rmtblbdr.build());
                    }
                });
            }
            return bldr.build();
        }
    }
}

