/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.composer;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.composer.AllPackages;
import com.artipie.composer.JsonPackage;
import com.artipie.composer.JsonPackages;
import com.artipie.composer.Name;
import com.artipie.composer.Packages;
import com.artipie.composer.Repository;
import com.artipie.composer.http.Archive;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

public final class AstoRepository
implements Repository {
    public static final Key ALL_PACKAGES = new AllPackages();
    private final Storage asto;
    private final Optional<String> prefix;

    public AstoRepository(Storage storage) {
        this(storage, Optional.empty());
    }

    public AstoRepository(Storage storage, Optional<String> prefix) {
        this.asto = storage;
        this.prefix = prefix;
    }

    @Override
    public CompletionStage<Optional<Packages>> packages() {
        return this.packages(ALL_PACKAGES);
    }

    @Override
    public CompletionStage<Optional<Packages>> packages(Name name) {
        return this.packages(name.key());
    }

    @Override
    public CompletableFuture<Void> addJson(Content content, Optional<String> vers) {
        Key.From key = new Key.From(UUID.randomUUID().toString());
        return this.asto.save((Key)key, content).thenCompose(arg_0 -> this.lambda$addJson$7((Key)key, vers, arg_0));
    }

    @Override
    public CompletableFuture<Void> addArchive(Archive archive, Content content) {
        Key.From key = new Key.From(new String[]{"artifacts", archive.name().full()});
        Key.From rand = new Key.From(UUID.randomUUID().toString());
        Key.From tmp = new Key.From((Key)rand, new String[]{archive.name().full()});
        return this.asto.save((Key)key, content).thenCompose(arg_0 -> this.lambda$addArchive$16((Key)key, archive, (Key)tmp, arg_0));
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return this.asto.value(key);
    }

    @Override
    public Storage storage() {
        return this.asto;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return this.asto.exists(key);
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return this.asto.save(key, content);
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return this.asto.exclusively(key, operation);
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return this.asto.move(source, destination);
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.asto.delete(key);
    }

    private static JsonObject addVersion(JsonObject compos, Archive.Name name) {
        return Json.createObjectBuilder((JsonObject)compos).add("version", name.version()).build();
    }

    private byte[] addDist(JsonObject compos, Key path) {
        String url = this.prefix.orElseThrow(() -> new IllegalStateException("Prefix url for `dist` for uploaded archive was empty.")).replaceAll("/$", "");
        try {
            return Json.createObjectBuilder((JsonObject)compos).add("dist", (JsonValue)Json.createObjectBuilder().add("url", new URI(String.format("%s/%s", url, path.string())).toString()).add("type", "zip").build()).build().toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (URISyntaxException exc) {
            throw new IllegalStateException(String.format("Failed to combine url `%s` with path `%s`", url, path.string()), exc);
        }
    }

    private CompletionStage<Optional<Packages>> packages(Key key) {
        return this.asto.exists(key).thenCompose(exists -> {
            CompletionStage packages = exists != false ? ((CompletableFuture)this.asto.value(key).thenApply(JsonPackages::new)).thenApply(Optional::of) : CompletableFuture.completedFuture(Optional.empty());
            return packages;
        });
    }

    private /* synthetic */ CompletionStage lambda$addArchive$16(Key key, Archive archive, Key tmp, Void nothing) {
        return this.asto.value(key).thenCompose(cont -> archive.composerFrom((Content)cont).thenApply(compos -> AstoRepository.addVersion(compos, archive.name())).thenCombine(this.asto.value(key), (compos, cnt) -> archive.replaceComposerWith((Content)cnt, compos.toString().getBytes(StandardCharsets.UTF_8)).thenCompose(arch -> this.asto.save(tmp, arch)).thenCompose(noth -> this.asto.delete(key)).thenCompose(noth -> this.asto.move(tmp, key)).thenCombine(this.packages(), (noth, packages) -> ((Packages)packages.orElse(new JsonPackages())).add(new JsonPackage((Content)new Content.From(this.addDist((JsonObject)compos, key))), Optional.empty()).thenCompose(pkgs -> pkgs.save(this.asto, ALL_PACKAGES))).thenCompose(Function.identity())).thenCompose(Function.identity()));
    }

    private /* synthetic */ CompletionStage lambda$addJson$7(Key key, Optional vers, Void nothing) {
        return ((CompletableFuture)((CompletableFuture)this.asto.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenCompose(bytes -> {
            JsonPackage pack = new JsonPackage((Content)new Content.From(bytes));
            return CompletableFuture.allOf(this.packages().thenCompose(packages -> ((Packages)packages.orElse(new JsonPackages())).add(pack, vers).thenCompose(pkgs -> pkgs.save(this.asto, ALL_PACKAGES))).toCompletableFuture(), pack.name().thenCompose(name -> this.packages((Name)name).thenCompose(packages -> ((Packages)packages.orElse(new JsonPackages())).add(pack, vers).thenCompose(pkgs -> pkgs.save(this.asto, name.key())))).toCompletableFuture()).thenCompose(ignored -> this.asto.delete(key));
        });
    }
}

