/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.asto;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.misc.UncheckedIOConsumer;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.conda.meta.MergedJson;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.json.JsonObject;
import org.cqfn.rio.Buffers;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.stream.ReactiveInputStream;
import org.cqfn.rio.stream.ReactiveOutputStream;
import org.reactivestreams.Publisher;

public final class AstoMergedJson {
    private final Storage asto;
    private final Key key;

    public AstoMergedJson(Storage asto, Key key) {
        this.asto = asto;
        this.key = key;
    }

    public CompletionStage<Void> merge(Map<String, JsonObject> items) {
        return this.asto.exists(this.key).thenCompose(exists -> {
            CompletionStage future;
            Optional<Object> pis = Optional.empty();
            Optional<Object> pos = Optional.empty();
            try {
                try (PipedOutputStream outout = new PipedOutputStream();){
                    CompletionStage<Void> tmp;
                    if (exists.booleanValue()) {
                        pis = Optional.of(new PipedInputStream());
                        PipedOutputStream out = new PipedOutputStream((PipedInputStream)pis.get());
                        pos = Optional.of(out);
                        tmp = this.asto.value(this.key).thenCompose(input -> new ReactiveOutputStream((OutputStream)out).write((Publisher)input, WriteGreed.SYSTEM));
                    } else {
                        tmp = CompletableFuture.allOf(new CompletableFuture[0]);
                        pis = Optional.empty();
                    }
                    PipedInputStream src = new PipedInputStream(outout);
                    future = tmp.thenCompose(nothing -> this.asto.save(this.key, (Content)new Content.From(new ReactiveInputStream((InputStream)src).read((Buffers)Buffers.Standard.K16))));
                    JsonFactory factory = new JsonFactory();
                    new MergedJson.Jackson(factory.createGenerator((OutputStream)outout), pis.map(new UncheckedIOFunc(arg_0 -> ((JsonFactory)factory).createParser(arg_0)))).merge(items);
                }
                pis.ifPresent((Consumer<Object>)new UncheckedIOConsumer(PipedInputStream::close));
                pos.ifPresent((Consumer<Object>)new UncheckedIOConsumer(PipedOutputStream::close));
            }
            catch (IOException err) {
                try {
                    throw new ArtipieIOException(err);
                }
                catch (Throwable throwable) {
                    pis.ifPresent((Consumer<Object>)new UncheckedIOConsumer(PipedInputStream::close));
                    pos.ifPresent((Consumer<Object>)new UncheckedIOConsumer(PipedOutputStream::close));
                    throw throwable;
                }
            }
            return future;
        });
    }
}

