/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.meta;

import com.artipie.ArtipieException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;

public interface InfoIndex {
    public static final String FILE_NAME = "info/index.json";

    public JsonObject json() throws IOException;

    public static final class Conda
    implements InfoIndex {
        private final InputStream input;

        public Conda(InputStream input) {
            this.input = input;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public JsonObject json() throws IOException {
            block19: {
                try {
                    archive = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(this.input));
                    var2_3 = null;
                    ** try [egrp 1[TRYBLOCK] [2, 4 : 24->155)] { 
lbl5:
                    // 1 sources

                    break block19;
lbl6:
                    // 1 sources

                    catch (Throwable var3_6) {
                        var2_3 = var3_6;
                        throw var3_6;
                    }
                }
                catch (ArchiveException ex) {
                    throw new IOException(ex);
                }
            }
            block14: while (true) {
                if ((entry = archive.getNextEntry()) == null) throw new ArtipieException("Illegal package `.conda`: info/index.json file not found");
                if (!archive.canReadEntryData(entry) || entry.isDirectory() || !(name = entry.getName()).startsWith("info") || !name.endsWith("tar.zst")) continue;
                info = new TarArchiveInputStream((InputStream)new ZstdCompressorInputStream((InputStream)archive));
                do {
                    if ((entry = info.getNextEntry()) != null) ** break;
                    continue block14;
                } while (!info.canReadEntryData(entry) || entry.isDirectory() || !"info/index.json".equals(entry.getName()));
                break;
            }
            return Json.createReader((InputStream)info).readObject();
lbl21:
            // 1 sources

            finally {
                if (archive != null) {
                    if (var2_3 != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable var7_10) {
                            var2_3.addSuppressed(var7_10);
                        }
                    } else {
                        archive.close();
                    }
                }
            }
        }
    }

    public static final class TarBz
    implements InfoIndex {
        private final InputStream input;

        public TarBz(InputStream input) {
            this.input = input;
        }

        @Override
        public JsonObject json() throws IOException {
            try (TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(this.input));){
                ArchiveEntry entry;
                while ((entry = archive.getNextEntry()) != null) {
                    if (!archive.canReadEntryData(entry) || entry.isDirectory() || !InfoIndex.FILE_NAME.equals(entry.getName())) continue;
                    JsonObject jsonObject = Json.createReader((InputStream)archive).readObject();
                    return jsonObject;
                }
            }
            throw new ArtipieException("Illegal package .tar.bz2: info/index.json file not found");
        }
    }
}

