/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda;

import com.artipie.asto.ArtipieIOException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public interface MultiRepodata {
    public void merge(Collection<InputStream> var1, OutputStream var2);

    public static final class Unique
    implements MultiRepodata {
        private static final String EXT = "json";
        private static final String FIELD = "packages.conda";
        private final Set<String> pckgs = new HashSet<String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void merge(Collection<InputStream> inputs, OutputStream result) {
            JsonFactory factory = new JsonFactory();
            try {
                Path ftars = Files.createTempFile("tars", EXT, new FileAttribute[0]);
                Path fcondas = Files.createTempFile("condas", EXT, new FileAttribute[0]);
                try {
                    Throwable throwable;
                    try (BufferedOutputStream otars = new BufferedOutputStream(Files.newOutputStream(ftars, new OpenOption[0]));){
                        throwable = null;
                        try (BufferedOutputStream ocondas = new BufferedOutputStream(Files.newOutputStream(fcondas, new OpenOption[0]));){
                            JsonGenerator tars = factory.createGenerator((OutputStream)otars);
                            JsonGenerator condas = factory.createGenerator((OutputStream)ocondas);
                            tars.writeStartObject();
                            condas.writeStartObject();
                            for (InputStream item : inputs) {
                                this.processInput(factory.createParser(item), tars, condas);
                            }
                            tars.close();
                            condas.close();
                        }
                        catch (Throwable tars) {
                            throwable = tars;
                            throw tars;
                        }
                    }
                    var7_8 = null;
                    try (BufferedInputStream itars = new BufferedInputStream(Files.newInputStream(ftars, new OpenOption[0]));){
                        throwable = null;
                        try (BufferedInputStream icondas = new BufferedInputStream(Files.newInputStream(fcondas, new OpenOption[0]));){
                            JsonGenerator res = factory.createGenerator(result);
                            res.writeStartObject();
                            Unique.writePackages(factory.createParser((InputStream)itars), res, "packages");
                            Unique.writePackages(factory.createParser((InputStream)icondas), res, FIELD);
                            res.writeEndObject();
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        var7_8 = throwable3;
                        throw throwable3;
                    }
                }
                finally {
                    Files.delete(ftars);
                    Files.delete(fcondas);
                }
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }

        private void processInput(JsonParser parser, JsonGenerator tars, JsonGenerator condas) throws IOException {
            JsonToken token;
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME && !FIELD.equals(parser.getCurrentName()) && parser.getCurrentName().endsWith(".conda")) {
                    this.writeItem(parser, condas);
                    continue;
                }
                if (token != JsonToken.FIELD_NAME || !parser.getCurrentName().endsWith(".tar.bz2")) continue;
                this.writeItem(parser, tars);
            }
        }

        private void writeItem(JsonParser parser, JsonGenerator generator) throws IOException {
            String name = parser.getCurrentName();
            parser.nextToken();
            parser.setCodec((ObjectCodec)new ObjectMapper());
            ObjectNode nodes = (ObjectNode)parser.readValueAsTree();
            if (this.pckgs.add(name)) {
                generator.writeFieldName(name);
                generator.setCodec((ObjectCodec)new ObjectMapper());
                generator.writeTree((TreeNode)nodes);
            }
        }

        private static void writePackages(JsonParser parser, JsonGenerator res, String field) throws IOException {
            res.writeFieldName(field);
            while (parser.nextToken() != null) {
                res.copyCurrentEvent(parser);
            }
        }
    }
}

