/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.asto;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.conda.meta.MergedJson;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.json.JsonObject;

public final class AstoMergedJson {
    private final Storage asto;
    private final Key key;

    public AstoMergedJson(Storage asto, Key key) {
        this.asto = asto;
        this.key = key;
    }

    public CompletionStage<Void> merge(Map<String, JsonObject> items) {
        return new StorageValuePipeline(this.asto, this.key).process((opt, out) -> {
            try {
                JsonFactory factory = new JsonFactory();
                new MergedJson.Jackson(factory.createGenerator(out), opt.map(new UncheckedIOFunc(arg_0 -> ((JsonFactory)factory).createParser(arg_0)))).merge(items);
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        });
    }
}

