/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.misc.UncheckedIOScalar;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.conda.asto.AstoMergedJson;
import com.artipie.conda.meta.InfoIndex;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentDisposition;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.multipart.RqMultipart;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import io.reactivex.Flowable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;
import org.reactivestreams.Publisher;

public final class UpdateSlice
implements Slice {
    private static final Pattern PKG = Pattern.compile(".*/((.*)/(.*(\\.tar\\.bz2|\\.conda)))$");
    private static final Key TMP = new Key.From("./upload");
    private final Storage asto;

    public UpdateSlice(Storage asto) {
        this.asto = asto;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus res;
        Matcher matcher = PKG.matcher(new RequestLineFrom(line).uri().getPath());
        if (matcher.matches()) {
            Key.From temp = new Key.From(TMP, new String[]{matcher.group(1)});
            res = new AsyncResponse(((CompletableFuture)this.asto.exists((Key)new Key.From(matcher.group(1))).thenCompose(arg_0 -> this.lambda$response$1((Key)temp, arg_0))).thenCompose(arg_0 -> this.lambda$response$8((Key)temp, headers, body, matcher, arg_0)));
        } else {
            res = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return res;
    }

    private CompletionStage<JsonObjectBuilder> addChecksum(Key key, Digests alg, JsonObjectBuilder json) {
        return ((CompletableFuture)this.asto.value(key).thenCompose(val -> new ContentDigest(val, (Supplier)alg).hex())).thenApply(hex -> json.add(alg.name().toLowerCase(Locale.US), hex));
    }

    private CompletionStage<JsonObjectBuilder> infoJson(String name, Key key) {
        return this.asto.value(key).thenCompose(val -> new ContentAsStream((Publisher)val).process(input -> {
            InfoIndex info = name.endsWith("conda") ? new InfoIndex.Conda((InputStream)input) : new InfoIndex.TarBz((InputStream)input);
            return Json.createObjectBuilder((JsonObject)((JsonObject)new UncheckedIOScalar(info::json).value())).add("size", ((Long)val.size().get()).longValue());
        }));
    }

    private static Publisher<ByteBuffer> filePart(Headers headers, Publisher<ByteBuffer> body) {
        return Flowable.fromPublisher((Publisher)new RqMultipart(headers, body).filter(hdrs -> new ContentDisposition(hdrs).fieldName().equals("file"))).flatMap(part -> part);
    }

    private /* synthetic */ CompletionStage lambda$response$8(Key temp, Iterable headers, Publisher body, Matcher matcher, Boolean exists) {
        CompletionStage<Object> resp = exists != false ? CompletableFuture.completedFuture(new RsWithStatus(RsStatus.BAD_REQUEST)) : ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.asto.save(temp, (Content)new Content.From(UpdateSlice.filePart((Headers)new Headers.From(headers), (Publisher<ByteBuffer>)body))).thenCompose(empty -> this.infoJson(matcher.group(1), temp))).thenCompose(json -> this.addChecksum(temp, Digests.MD5, (JsonObjectBuilder)json))).thenCompose(json -> this.addChecksum(temp, Digests.SHA256, (JsonObjectBuilder)json))).thenApply(JsonObjectBuilder::build)).thenCompose(json -> new AstoMergedJson(this.asto, (Key)new Key.From(new String[]{matcher.group(2), "repodata.json"})).merge((Map<String, JsonObject>)new MapOf(new Map.Entry[]{new MapEntry((Object)matcher.group(3), json)})))).thenCompose(ignored -> this.asto.move(temp, (Key)new Key.From(matcher.group(1))))).thenApply(ignored -> new RsWithStatus(RsStatus.CREATED));
        return resp;
    }

    private /* synthetic */ CompletionStage lambda$response$1(Key temp, Boolean main) {
        return this.asto.exists(temp).thenApply(upl -> main != false || upl != false);
    }
}

