/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.meta;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Set;

public interface JsonMaid {
    public void clean(Set<String> var1) throws IOException;

    public static final class Jackson
    implements JsonMaid {
        private final JsonGenerator gnrt;
        private final JsonParser parser;

        public Jackson(JsonGenerator gnrt, JsonParser parser) {
            this.gnrt = gnrt;
            this.parser = parser;
        }

        @Override
        public void clean(Set<String> checksums) throws IOException {
            JsonToken token;
            while ((token = this.parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME && !"packages.conda".equals(this.parser.getCurrentName()) && (this.parser.getCurrentName().endsWith("tar.bz2") || this.parser.getCurrentName().endsWith(".conda"))) {
                    String name = this.parser.getCurrentName();
                    this.parser.nextToken();
                    this.parser.setCodec((ObjectCodec)new ObjectMapper());
                    ObjectNode nodes = (ObjectNode)this.parser.readValueAsTree();
                    if (checksums.contains(nodes.get("sha256").asText())) continue;
                    this.gnrt.writeFieldName(name);
                    this.gnrt.setCodec((ObjectCodec)new ObjectMapper());
                    this.gnrt.writeTree((TreeNode)nodes);
                    continue;
                }
                this.gnrt.copyCurrentEvent(this.parser);
            }
            this.gnrt.close();
            this.parser.close();
        }
    }
}

