/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface AuthTokens {
    public static final AuthTokens ANONYMOUS = new AuthTokens(){

        @Override
        public CompletionStage<Optional<TokenItem>> get(String token) {
            return CompletableFuture.completedFuture(Optional.of(new TokenItem("any", "anonymous", Instant.MAX)));
        }

        @Override
        public CompletionStage<Optional<TokenItem>> find(String username) {
            return this.get("any");
        }

        @Override
        public CompletionStage<TokenItem> generate(String name, Duration ttl) {
            return this.get("any").thenApply(res -> (TokenItem)res.get());
        }

        @Override
        public CompletionStage<Boolean> remove(String token) {
            return CompletableFuture.completedFuture(true);
        }
    };

    public CompletionStage<Optional<TokenItem>> get(String var1);

    public CompletionStage<Optional<TokenItem>> find(String var1);

    public CompletionStage<TokenItem> generate(String var1, Duration var2);

    public CompletionStage<Boolean> remove(String var1);

    public static final class TokenItem {
        private final String uname;
        private final String tkn;
        private final Instant expire;

        public TokenItem(String token, String uname, Instant expire) {
            this.tkn = token;
            this.uname = uname;
            this.expire = expire;
        }

        public TokenItem(String token, ObjectNode info) {
            this(token, info.get("name").textValue(), Instant.ofEpochMilli(info.get("expire").longValue()));
        }

        public String userName() {
            return this.uname;
        }

        public boolean expired() {
            return this.expire.compareTo(Instant.now()) < 0;
        }

        public String token() {
            return this.tkn;
        }

        public Instant validUntil() {
            return this.expire;
        }

        public boolean equals(Object other) {
            boolean res;
            if (this == other) {
                res = true;
            } else if (other == null || this.getClass() != other.getClass()) {
                res = false;
            } else {
                TokenItem item = (TokenItem)other;
                res = this.uname.equals(item.uname) && this.tkn.equals(item.tkn) && this.expire.equals(item.expire);
            }
            return res;
        }

        public int hashCode() {
            return Objects.hash(this.tkn, this.uname, this.expire);
        }
    }
}

