/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.asto;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.misc.UncheckedIOConsumer;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.conda.AuthTokens;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.lang3.RandomStringUtils;
import org.reactivestreams.Publisher;

public final class AstoAuthTokens
implements AuthTokens {
    static final Key TKNS = new Key.From(".tokens.json");
    static final String TOKENS = "tokens";
    private static final int LEN = 30;
    private final Storage asto;

    public AstoAuthTokens(Storage asto) {
        this.asto = asto;
    }

    @Override
    public CompletionStage<Optional<AuthTokens.TokenItem>> get(String token) {
        return this.checkAndFind(AstoAuthTokens.findByToken(token));
    }

    @Override
    public CompletionStage<Optional<AuthTokens.TokenItem>> find(String username) {
        return this.checkAndFind(AstoAuthTokens.findByUsername(username));
    }

    @Override
    public CompletionStage<AuthTokens.TokenItem> generate(String name, Duration ttl) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> RandomStringUtils.random((int)30, (boolean)true, (boolean)true)).thenApply(str -> new AuthTokens.TokenItem((String)str, name, Instant.now().plus(ttl)))).thenCompose(token -> new StorageValuePipeline(this.asto, TKNS).process((opt, out) -> {
            JsonFactory fact = new JsonFactory();
            Optional parser = opt.map(new UncheckedIOFunc(arg_0 -> ((JsonFactory)fact).createParser(arg_0)));
            try (JsonGenerator gen = fact.createGenerator(out);){
                gen.writeStartObject();
                gen.writeFieldName(TOKENS);
                gen.writeStartObject();
                parser.ifPresent(item -> AstoAuthTokens.copy(gen, item));
                gen.writeFieldName(token.token());
                gen.writeStartObject();
                gen.writeStringField("name", name);
                gen.writeNumberField("expire", token.validUntil().toEpochMilli());
                gen.writeEndObject();
                gen.writeEndObject();
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
            finally {
                parser.ifPresent(new UncheckedIOConsumer(JsonParser::close));
            }
        }).thenApply(nothing -> token));
    }

    @Override
    public CompletionStage<Boolean> remove(String token) {
        return new StorageValuePipeline(this.asto, TKNS).processWithResult((opt, out) -> {
            boolean removed = false;
            if (opt.isPresent()) {
                removed = AstoAuthTokens.copyExcept((InputStream)opt.get(), out, token);
            }
            return removed;
        });
    }

    private CompletionStage<Optional<AuthTokens.TokenItem>> checkAndFind(Function<InputStream, Optional<AuthTokens.TokenItem>> action) {
        return this.asto.exists(TKNS).thenCompose(exists -> {
            CompletionStage res = CompletableFuture.completedFuture(Optional.empty());
            if (exists.booleanValue()) {
                res = this.asto.value(TKNS).thenCompose(pub -> new ContentAsStream((Publisher)pub).process(action));
            }
            return res;
        });
    }

    private static Function<InputStream, Optional<AuthTokens.TokenItem>> findByToken(String token) {
        return input -> {
            try {
                JsonToken jtoken;
                JsonParser parser = new JsonFactory().createParser(input);
                Optional<Object> result = Optional.empty();
                while ((jtoken = parser.nextToken()) != null) {
                    if (jtoken != JsonToken.FIELD_NAME || !parser.getCurrentName().equals(token)) continue;
                    parser.nextToken();
                    parser.setCodec((ObjectCodec)new ObjectMapper());
                    AuthTokens.TokenItem item = new AuthTokens.TokenItem(token, (ObjectNode)parser.readValueAsTree());
                    if (item.expired()) continue;
                    result = Optional.of(item);
                }
                return result;
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        };
    }

    private static Function<InputStream, Optional<AuthTokens.TokenItem>> findByUsername(String name) {
        return input -> {
            try {
                JsonToken jtoken;
                JsonParser parser = new JsonFactory().createParser(input);
                Optional<Object> result = Optional.empty();
                while ((jtoken = parser.nextToken()) != null) {
                    if (jtoken != JsonToken.FIELD_NAME || parser.getCurrentName().equals(TOKENS)) continue;
                    String token = parser.getCurrentName();
                    parser.nextToken();
                    parser.setCodec((ObjectCodec)new ObjectMapper());
                    AuthTokens.TokenItem item = new AuthTokens.TokenItem(token, (ObjectNode)parser.readValueAsTree());
                    if (!name.equals(item.userName()) || item.expired()) continue;
                    result = Optional.of(item);
                }
                return result;
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        };
    }

    private static void copy(JsonGenerator gen, JsonParser parser) {
        try {
            JsonToken jtoken;
            while ((jtoken = parser.nextToken()) != null) {
                if (jtoken != JsonToken.FIELD_NAME || parser.getCurrentName().equals(TOKENS)) continue;
                String token = parser.getCurrentName();
                parser.nextToken();
                parser.setCodec((ObjectCodec)new ObjectMapper());
                gen.writeFieldName(token);
                gen.setCodec((ObjectCodec)new ObjectMapper());
                gen.writeTree(parser.readValueAsTree());
            }
        }
        catch (IOException err) {
            throw new ArtipieIOException(err);
        }
    }

    private static boolean copyExcept(InputStream input, OutputStream out, String token) {
        JsonFactory fact = new JsonFactory();
        boolean found = false;
        try (JsonGenerator gen = fact.createGenerator(out);
             JsonParser parser = fact.createParser(input);){
            JsonToken jtoken;
            gen.writeStartObject();
            gen.writeFieldName(TOKENS);
            gen.writeStartObject();
            while ((jtoken = parser.nextToken()) != null) {
                if (jtoken != JsonToken.FIELD_NAME || parser.getCurrentName().equals(TOKENS)) continue;
                String current = parser.getCurrentName();
                parser.nextToken();
                parser.setCodec((ObjectCodec)new ObjectMapper());
                ObjectNode node = (ObjectNode)parser.readValueAsTree();
                if (current.equals(token)) {
                    found = true;
                    continue;
                }
                gen.writeFieldName(current);
                gen.setCodec((ObjectCodec)new ObjectMapper());
                gen.writeTree((TreeNode)node);
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }
        catch (IOException err) {
            throw new ArtipieIOException(err);
        }
        return found;
    }
}

