/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.asto;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Storage;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.conda.AuthTokens;
import com.artipie.conda.asto.AstoAuthTokens;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class AuthTokensMaid {
    private final Storage asto;

    public AuthTokensMaid(Storage asto) {
        this.asto = asto;
    }

    public CompletionStage<Void> clean() {
        return this.asto.exists(AstoAuthTokens.TKNS).thenCompose(exists -> {
            CompletionStage<Void> res = CompletableFuture.allOf(new CompletableFuture[0]);
            if (exists.booleanValue()) {
                res = new StorageValuePipeline(this.asto, AstoAuthTokens.TKNS).process((opt, out) -> opt.ifPresent(inputStream -> AuthTokensMaid.copyValidTokens(inputStream, out)));
            }
            return res;
        });
    }

    private static void copyValidTokens(InputStream input, OutputStream out) {
        JsonFactory fact = new JsonFactory();
        try (JsonGenerator gen = fact.createGenerator(out);
             JsonParser parser = fact.createParser(input);){
            JsonToken jtoken;
            gen.writeStartObject();
            gen.writeFieldName("tokens");
            gen.writeStartObject();
            while ((jtoken = parser.nextToken()) != null) {
                if (jtoken != JsonToken.FIELD_NAME || parser.getCurrentName().equals("tokens")) continue;
                String token = parser.getCurrentName();
                parser.nextToken();
                parser.setCodec((ObjectCodec)new ObjectMapper());
                ObjectNode node = (ObjectNode)parser.readValueAsTree();
                AuthTokens.TokenItem item = new AuthTokens.TokenItem(token, node);
                if (item.expired()) continue;
                gen.writeFieldName(token);
                gen.setCodec((ObjectCodec)new ObjectMapper());
                gen.writeTree((TreeNode)node);
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }
        catch (IOException err) {
            throw new ArtipieIOException(err);
        }
    }
}

